/*
 * Decompiled with CFR 0.152.
 */
package com.me4502.slotmachines.util;

import java.util.Optional;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;

public class LocationUtil {
    public static Direction getClockWise(Direction face) {
        switch (face) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return face;
    }

    public static Direction getCounterClockWise(Direction face) {
        switch (face) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return face;
    }

    public static Direction getFront(Location<?> sign) {
        Optional data = sign.get(Keys.DIRECTION);
        return data.orElse(Direction.NONE);
    }

    public static Direction getBack(Location sign) {
        Direction front = LocationUtil.getFront(sign);
        if (front == null) {
            return Direction.NONE;
        }
        return front.getOpposite();
    }

    public static Location<?> getBackBlock(Location<?> sign) {
        return sign.getRelative(LocationUtil.getBack(sign));
    }

    public static Direction getRight(Location<?> sign) {
        Direction front = LocationUtil.getFront(sign);
        if (front == null) {
            return Direction.NONE;
        }
        return LocationUtil.getClockWise(front);
    }

    public static Location<?> getLeftBlock(Location<?> sign) {
        return sign.getRelative(LocationUtil.getLeft(sign));
    }

    public static Direction getLeft(Location<?> sign) {
        Direction front = LocationUtil.getFront(sign);
        if (front == null) {
            return Direction.NONE;
        }
        return LocationUtil.getCounterClockWise(front);
    }

    public static Location<?> getRightBlock(Location<?> sign) {
        return sign.getRelative(LocationUtil.getRight(sign));
    }

    public static String getTextRaw(Sign sign, int line) {
        return LocationUtil.getTextRaw((SignData)sign.get(SignData.class).get(), line);
    }

    public static String getTextRaw(SignData sign, int line) {
        Text text = LocationUtil.getText(sign, line);
        return text.toPlain();
    }

    public static Text getText(SignData sign, int line) {
        return (Text)sign.lines().get(line);
    }
}

