/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography;

import com.bloodnbonesgaming.lib.util.FileHelper;
import com.bloodnbonesgaming.lib.util.script.ScriptUtil;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.LockHandler;
import com.bloodnbonesgaming.topography.util.FixedTemplate;
import com.bloodnbonesgaming.topography.world.biome.provider.BiomeProviderScripted;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.WorldInfo;

public class IOHelper {
    public static void readMainFile(ConfigurationManager config, Map<String, Class> classKeywords) {
        File file = new File("./config/topography/Topography.txt");
        if (!file.exists()) {
            FileHelper.copyDirectoryFromJar(IOHelper.class, (String)"/defaultconfigs/", (String)"./config/topography/");
            ConfigurationManager.printDocumentation();
        }
        ScriptUtil.readScript((File)file, (Object)config, classKeywords);
    }

    public static Template loadStructureTemplate(String name) {
        File file = new File("./config/topography/structures/" + name + ".nbt");
        try {
            FileInputStream stream = new FileInputStream(file);
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
            stream.close();
            FixedTemplate template = new FixedTemplate();
            template.func_186256_b(nbt);
            return template;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadImage(String name) {
        File file = new File("./config/topography/" + name + ".png");
        if (file.exists()) {
            try {
                return ImageIO.read(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean loadDimensionDefinition(String name, DimensionDefinition definition) {
        return ScriptUtil.readScript((File)new File("./config/topography/" + name + ".txt"), (Object)definition, definition.classKeywords);
    }

    public static boolean loadBiomeProvider(String name, BiomeProviderScripted provider, Map<String, Class> keywords, Map<String, Object> localVariables) {
        return ScriptUtil.readScript((File)new File("./config/topography/" + name + ".txt"), (Object)((Object)provider), keywords, localVariables);
    }

    public static boolean loadUnlockFile(LockHandler handler) {
        File file = new File("./topography/data/unlocks.txt");
        if (!file.exists()) {
            return false;
        }
        return ScriptUtil.readScript((File)new File("./topography/data/unlocks.txt"), (Object)handler, null);
    }

    public static void saveUnlockFile(LockHandler handler) {
        File file = new File("./topography/data/unlocks.txt");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        FileHelper.writeText((File)file, (String)handler.getUnlocks());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorldInfo readWorldInfo(String serverFolderName) {
        File worldDirectory = new File(((AnvilSaveConverter)Minecraft.func_71410_x().func_71359_d()).field_75808_a, serverFolderName);
        File file = new File(worldDirectory, "level.dat");
        try (FileInputStream stream = new FileInputStream(file);){
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)stream);
            NBTTagCompound data = compound.func_74775_l("Data");
            WorldInfo worldInfo = new WorldInfo(data);
            return worldInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

