/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.command.island;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.StructureHelper;
import com.bloodnbonesgaming.topography.command.island.IslandHome;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.event.EventSubscriber;
import com.bloodnbonesgaming.topography.util.SpawnStructure;
import com.bloodnbonesgaming.topography.util.capabilities.ITopographyPlayerData;
import com.bloodnbonesgaming.topography.util.capabilities.TopographyPlayerData;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;

public class IslandSet
extends CommandBase {
    final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "set";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /topography island set [player]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        CommandBase.CoordinateArg z;
        CommandBase.CoordinateArg x;
        ITopographyPlayerData data;
        DimensionDefinition dimensionDef;
        ConfigPreset preset;
        ConfigurationManager manager;
        EntityPlayerMP player;
        WorldServer world = DimensionManager.getWorld((int)0);
        if (args.length == 2) {
            if (!(sender instanceof EntityPlayerMP)) throw new CommandException("Command must have a target argument if not run by a player.", new Object[0]);
            player = (EntityPlayerMP)sender;
            manager = ConfigurationManager.getInstance();
            if (manager == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
            preset = manager.getPreset();
            if (preset == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
            dimensionDef = preset.getDefinition(world.field_73011_w.getDimension());
            if (dimensionDef == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
            data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
            x = CommandBase.func_175770_a((double)player.field_70165_t, (String)args[0], (boolean)false);
            z = CommandBase.func_175770_a((double)player.field_70161_v, (String)args[1], (boolean)false);
            data.setIsland((int)x.func_179629_b(), (int)z.func_179629_b());
        } else {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            if (player == null) {
                throw new CommandException("The entity selected (%s) is not a valid player.", new Object[]{args[0]});
            }
            manager = ConfigurationManager.getInstance();
            if (manager == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
            preset = manager.getPreset();
            if (preset == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
            dimensionDef = preset.getDefinition(world.field_73011_w.getDimension());
            if (dimensionDef == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
            data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
            x = CommandBase.func_175770_a((double)player.field_70165_t, (String)args[1], (boolean)false);
            z = CommandBase.func_175770_a((double)player.field_70161_v, (String)args[2], (boolean)false);
            data.setIsland((int)x.func_179629_b(), (int)z.func_179629_b());
        }
        manager = ConfigurationManager.getInstance();
        if (manager == null || (preset = manager.getPreset()) == null || (dimensionDef = preset.getDefinition(world.field_73011_w.getDimension())) == null) throw new CommandException("Unable to find a spawn structure or sky island in the dimension.", new Object[0]);
        SpawnStructure structure = dimensionDef.getSpawnStructure();
        if (structure != null) {
            BlockPos spawn;
            Template template = IOHelper.loadStructureTemplate(structure.getStructure());
            if (template == null || (spawn = StructureHelper.getSpawn(template)) == null) throw new CommandException("Unable to find a spawn structure or sky island in the dimension.", new Object[0]);
            ITopographyPlayerData data2 = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
            spawn = spawn.func_177982_a(data2.getIslandX(), 0, data2.getIslandZ());
            BlockPos pos = spawn.func_177982_a(0, structure.getHeight(), 0);
            player.func_145747_a((ITextComponent)new TextComponentString("Teleporting you to your structure."));
            player.func_180473_a(pos, true);
            this.teleportPlayer(player, 0, pos);
            return;
        }
        for (IGenerator generator : dimensionDef.getGenerators()) {
            if (!(generator instanceof SkyIslandGenerator)) continue;
            ITopographyPlayerData data3 = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
            BlockPos pos = new BlockPos(data3.getIslandX(), 0, data3.getIslandZ());
            pos = IslandHome.getTopSolidOrLiquidBlock((World)world, pos).func_177984_a();
            player.func_145747_a((ITextComponent)new TextComponentString("Teleporting you to your sky island."));
            player.func_180473_a(pos, true);
            this.teleportPlayer(player, 0, pos);
            return;
        }
        throw new CommandException("Unable to find a spawn structure or sky island in the dimension.", new Object[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public int func_82362_a() {
        return 0;
    }

    private void teleportPlayer(EntityPlayerMP player, int dimension, BlockPos pos) {
        if (player.field_70170_p.field_73011_w.getDimension() != dimension) {
            player.changeDimension(0, (ITeleporter)new EventSubscriber.ReTeleporter(pos));
        } else {
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

