/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.config;

import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.util.EDamageSource;
import com.bloodnbonesgaming.topography.util.EntityType;
import com.bloodnbonesgaming.topography.util.ExtendedDamageSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityEffect {
    private final int frequency;
    private List<ResourceLocation> effectedEntities = new ArrayList<ResourceLocation>();
    private List<EntityType> types = new ArrayList<EntityType>();
    private MinMaxBounds lightLevel = MinMaxBounds.field_192516_a;
    private Boolean canSeeSky = null;
    private final Map<DamageSource, Integer> damageMap = new LinkedHashMap<DamageSource, Integer>();
    private final Map<String, AttributeModifier> attributes = new HashMap<String, AttributeModifier>();

    public EntityEffect(int frequency) {
        this.frequency = frequency;
    }

    public void apply(EntityLivingBase entity) {
        if ((this.frequency == 0 || entity.func_130014_f_().func_82737_E() % (long)this.frequency == 0L) && this.acceptableEntity(entity) && this.acceptableLight(entity) && this.acceptableSky(entity)) {
            this.applyAttributes(entity);
            this.applyDamage(entity);
        }
    }

    private boolean acceptableEntity(EntityLivingBase entity) {
        if (!this.types.isEmpty()) {
            for (EntityType type : this.types) {
                if (!type.isAcceptable(entity)) continue;
                return true;
            }
            return false;
        }
        if (!this.effectedEntities.isEmpty()) {
            for (ResourceLocation location : this.effectedEntities) {
                EntityEntry entry;
                if (!(location.func_110623_a().equalsIgnoreCase("player") ? entity instanceof EntityPlayer : (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(location)) != null && entry.getEntityClass() == entity.getClass())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean acceptableLight(EntityLivingBase entity) {
        if (this.lightLevel != MinMaxBounds.field_192516_a) {
            return this.lightLevel.func_192514_a((float)entity.field_70170_p.func_175671_l(entity.func_180425_c()));
        }
        return true;
    }

    private boolean acceptableSky(EntityLivingBase entity) {
        return this.canSeeSky == null || entity.field_70170_p.func_175678_i(entity.func_180425_c()) == this.canSeeSky.booleanValue();
    }

    private void applyDamage(EntityLivingBase entity) {
        for (Map.Entry<DamageSource, Integer> entry : this.damageMap.entrySet()) {
            entity.func_70097_a(entry.getKey(), (float)entry.getValue().intValue());
        }
    }

    public void applyAttributes(EntityLivingBase entity) {
        for (Map.Entry<String, AttributeModifier> attribute : this.attributes.entrySet()) {
            IAttributeInstance instance = entity.func_110140_aT().func_111152_a(attribute.getKey());
            if (instance == null || instance.func_180374_a(attribute.getValue())) continue;
            instance.func_111121_a(attribute.getValue());
            if (!attribute.getKey().equals("generic.maxHealth")) continue;
            entity.func_70691_i(entity.func_110138_aP());
        }
    }

    public void addEntityType(String string) throws Exception {
        EntityType type = EntityType.valueOf(string.toUpperCase());
        if (type == null) {
            throw new Exception(string + " is not a valid entity type!");
        }
        this.types.add(type);
    }

    public void addDamage(String sourceString, int amount) {
        EDamageSource source = EDamageSource.valueOf(sourceString.toUpperCase());
        if (source != null) {
            this.damageMap.put(source.getSource(), amount);
        } else {
            Topography.instance.getLog().info((Object)(sourceString + " is not a valid damage source!"));
        }
    }

    public void addDamage(DamageSource source, int amount) {
        this.damageMap.put(source, amount);
    }

    public DamageSource addDamageSource(String name, String deathMessage, int amount) {
        ExtendedDamageSource source = new ExtendedDamageSource(name, deathMessage);
        this.damageMap.put(source, amount);
        return source;
    }

    public void setLightLevel(Float min, Float max) {
        this.lightLevel = new MinMaxBounds(min, max);
    }

    public void canSeeSky(boolean bool) {
        this.canSeeSky = bool;
    }

    public void addAttribute(String attribute, String modifierName, double amount, int operation) {
        this.attributes.put(attribute, new AttributeModifier(UUID.nameUUIDFromBytes(modifierName.getBytes()), modifierName, amount, operation));
    }
}

