/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.config;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/sky_islands/SkyIslandData", classExplaination="This file is for the SkyIslandData. This data object is for holding size and type data of islands for the SkyIslandGenerator.")
public class SkyIslandData {
    private int count = 1;
    private int radius = 100;
    private List<SkyIslandType> types = new ArrayList<SkyIslandType>();
    private boolean randomTypes = true;
    private int minCount = 0;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @ScriptMethodDocumentation(args="SkyIslandType", usage="type", notes="Adds a type of sky island to be generated.")
    public void addType(SkyIslandType type) {
        this.types.add(type);
    }

    public SkyIslandType getType(int index) {
        return this.types.get(index % this.types.size());
    }

    public SkyIslandType getType(Random rand) {
        return this.types.get(rand.nextInt(this.types.size()));
    }

    public boolean isRandomIslands() {
        return this.randomTypes;
    }

    public void setRandomTypes(boolean randomTypes) {
        this.randomTypes = randomTypes;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int count) {
        this.minCount = count;
    }
}

