/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.event;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.StructureHelper;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.command.island.IslandNew;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.EntityEffect;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.util.SpawnStructure;
import com.bloodnbonesgaming.topography.util.capabilities.ITopographyPlayerData;
import com.bloodnbonesgaming.topography.util.capabilities.TopographyPlayerData;
import com.bloodnbonesgaming.topography.world.WorldSavedDataTopography;
import com.bloodnbonesgaming.topography.world.WorldTypeCustomizable;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.CommandSenderWrapper;
import net.minecraft.command.FunctionObject;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventSubscriber {
    private boolean teleporting = false;

    @SubscribeEvent
    public void onCreateWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        DimensionDefinition dimensionDef;
        ConfigPreset preset;
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager != null && (preset = manager.getPreset()) != null && (dimensionDef = preset.getDefinition(event.getWorld().field_73011_w.getDimension())) != null) {
            for (IGenerator generator : dimensionDef.getGenerators()) {
                Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands;
                Iterator<Map.Entry<BlockPos, SkyIslandType>> positions;
                if (!(generator instanceof SkyIslandGenerator)) continue;
                SkyIslandGenerator islandGenerator = (SkyIslandGenerator)generator;
                Iterator<Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>>> iterator = islandGenerator.getIslandPositions(event.getWorld().func_72905_C(), 0, 0).entrySet().iterator();
                if (!iterator.hasNext() || !(positions = (islands = iterator.next()).getValue().entrySet().iterator()).hasNext()) break;
                Map.Entry<BlockPos, SkyIslandType> island = positions.next();
                BlockPos pos = island.getKey();
                BlockPos topBlock = event.getWorld().func_175672_r(pos);
                event.getWorld().func_72912_H().func_176143_a(topBlock.func_177984_a());
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onGetPotentialSpawns(WorldEvent.PotentialSpawns event) {
        if (event.getWorld().func_175624_G() instanceof WorldTypeCustomizable && event.getWorld().func_175726_f(event.getPos()).func_76621_g()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        DimensionDefinition dimensionDef;
        ConfigPreset preset;
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager != null && (preset = manager.getPreset()) != null && (dimensionDef = preset.getDefinition(event.getEntityLiving().field_70170_p.field_73011_w.getDimension())) != null) {
            for (EntityEffect effect : dimensionDef.getEntityEffects()) {
                effect.apply(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public void playerLoginEvent(final PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && ConfigurationManager.getInstance() != null) {
            NBTTagCompound persistent;
            NBTTagCompound nbt = event.player.getEntityData();
            if (!nbt.func_74764_b("PlayerPersisted")) {
                nbt.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            if (!(persistent = nbt.func_74775_l("PlayerPersisted")).func_74764_b("topography_initial") && ConfigurationManager.getInstance().getPreset() != null) {
                List<ResourceLocation> functions = ConfigurationManager.getInstance().getPreset().getInitialPlayerFunctions();
                for (ResourceLocation function : functions) {
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h();
                    FunctionObject functionobject = server.func_193030_aL().func_193058_a(function);
                    if (functionobject == null) continue;
                    Topography.instance.getLog().info((Object)("Running initial function " + function.toString() + " for player " + event.player.func_70005_c_()));
                    ICommandSender icommandsender = new ICommandSender(){

                        public String func_70005_c_() {
                            return event.player.func_70005_c_();
                        }

                        public ITextComponent func_145748_c_() {
                            return event.player.func_145748_c_();
                        }

                        public void func_145747_a(ITextComponent component) {
                        }

                        public boolean func_70003_b(int permLevel, String commandName) {
                            return true;
                        }

                        public BlockPos func_180425_c() {
                            return event.player.func_180425_c();
                        }

                        public Vec3d func_174791_d() {
                            return event.player.func_174791_d();
                        }

                        public World func_130014_f_() {
                            return event.player.field_70170_p;
                        }

                        public Entity func_174793_f() {
                            return event.player;
                        }

                        public boolean func_174792_t_() {
                            return true;
                        }

                        public void func_174794_a(CommandResultStats.Type type, int amount) {
                            event.player.func_174794_a(type, amount);
                        }

                        public MinecraftServer func_184102_h() {
                            return event.player.func_184102_h();
                        }
                    };
                    server.func_193030_aL().func_194019_a(functionobject, icommandsender);
                }
                persistent.func_74757_a("topography_initial", true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        JsonParser parser;
        JsonElement element;
        String settings;
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K && event.world.field_73011_w.getDimension() == 0 && !WorldSavedDataTopography.exists(event.world) && !(settings = event.world.func_72912_H().func_82571_y()).isEmpty() && (element = (parser = new JsonParser()).parse(settings)).isJsonObject() && ((JsonObject)element).has("Topography-Preset")) {
            ConfigPreset preset = ConfigurationManager.getInstance().getPreset();
            if (preset.getDifficulty() != null) {
                event.world.func_72912_H().func_176144_a(preset.getDifficulty());
            }
            if (preset.shouldLockDifficulty()) {
                event.world.func_72912_H().func_180783_e(true);
            }
            if (preset.hardcore()) {
                event.world.func_72912_H().func_176119_g(true);
            }
            List<ResourceLocation> functions = ConfigurationManager.getInstance().getPreset().getInitialServerFunctions();
            for (ResourceLocation function : functions) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h();
                FunctionObject functionobject = server.func_193030_aL().func_193058_a(function);
                if (functionobject == null) continue;
                Topography.instance.getLog().info((Object)("Running initial server function: " + function));
                server.func_193030_aL().func_194019_a(functionobject, (ICommandSender)CommandSenderWrapper.func_193998_a((ICommandSender)server).func_194000_i().func_193999_a(2).func_194001_a(false));
            }
            Iterator<Object> iterator = ConfigurationManager.getInstance().getPreset().getDimensions().iterator();
            while (iterator.hasNext()) {
                BlockPos spawn;
                int dimension = (Integer)iterator.next();
                String script = ConfigurationManager.getInstance().getPreset().getScript(dimension);
                DimensionDefinition definition = new DimensionDefinition();
                IOHelper.loadDimensionDefinition(script, definition);
                SpawnStructure structure = definition.getSpawnStructure();
                if (structure == null) continue;
                WorldServer dimWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
                Template template = IOHelper.loadStructureTemplate(structure.getStructure());
                if (template == null) continue;
                int preloadArea = template.func_186259_a().func_177958_n();
                preloadArea = template.func_186259_a().func_177952_p() > preloadArea ? template.func_186259_a().func_177952_p() : preloadArea;
                preloadArea /= 16;
                Topography.instance.getLog().info((Object)("Preloading " + ((preloadArea += 4) * 2 + 1) * (preloadArea * 2 + 1) + " chunks for spawn structure in dimension " + dimension));
                for (int x = -preloadArea; x < preloadArea; ++x) {
                    for (int z = -preloadArea; z < preloadArea; ++z) {
                        dimWorld.func_72863_F().func_186025_d(x, z);
                    }
                }
                Topography.instance.getLog().info((Object)("Spawning structure for dimension " + dimension));
                template.func_189962_a((World)dimWorld, new BlockPos(0, structure.getHeight(), 0), new PlacementSettings(), 2);
                if (dimension != 0 || (spawn = StructureHelper.getSpawn(template)) == null) continue;
                dimWorld.func_82736_K().func_82764_b("spawnRadius", "0");
                dimWorld.func_72912_H().func_176143_a(spawn.func_177982_a(0, structure.getHeight(), 0));
            }
        }
    }

    @SubscribeEvent
    public void onDimensionChange(EntityTravelToDimensionEvent event) {
        block5: {
            DimensionDefinition dimensionDef;
            WorldServer world;
            block6: {
                BlockPos spawn;
                SpawnStructure structure;
                ConfigPreset preset;
                if (this.teleporting) break block5;
                world = event.getEntity().func_130014_f_().func_73046_m().func_71218_a(event.getDimension());
                ConfigurationManager manager = ConfigurationManager.getInstance();
                if (manager == null || (preset = manager.getPreset()) == null || (dimensionDef = preset.getDefinition(world.field_73011_w.getDimension())) == null || !dimensionDef.shouldCaptureTeleports()) break block5;
                if (event.getEntity() instanceof EntityPlayer) {
                    BlockPos blockpos1;
                    EntityPlayer player = (EntityPlayer)event.getEntity();
                    BlockPos blockpos = player.getBedLocation(event.getDimension());
                    boolean forced = player.isSpawnForced(event.getDimension());
                    if (blockpos != null && (blockpos1 = EntityPlayer.func_180467_a((World)world, (BlockPos)blockpos, (boolean)forced)) != null) {
                        event.setCanceled(true);
                        this.teleporting = true;
                        event.getEntity().changeDimension(event.getDimension(), (ITeleporter)new ReTeleporter(blockpos1));
                        this.teleporting = false;
                        return;
                    }
                }
                if ((structure = dimensionDef.getSpawnStructure()) == null) break block6;
                Template template = IOHelper.loadStructureTemplate(structure.getStructure());
                if (template == null || (spawn = StructureHelper.getSpawn(template)) == null) break block5;
                ITopographyPlayerData data = (ITopographyPlayerData)event.getEntity().getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                if (data != null) {
                    spawn = spawn.func_177982_a(data.getIslandX(), 0, data.getIslandZ());
                }
                event.setCanceled(true);
                this.teleporting = true;
                event.getEntity().changeDimension(event.getDimension(), (ITeleporter)new ReTeleporter(spawn.func_177982_a(0, structure.getHeight(), 0)));
                this.teleporting = false;
                break block5;
            }
            for (IGenerator generator : dimensionDef.getGenerators()) {
                Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands;
                Iterator<Map.Entry<BlockPos, SkyIslandType>> positions;
                if (!(generator instanceof SkyIslandGenerator)) continue;
                SkyIslandGenerator islandGenerator = (SkyIslandGenerator)generator;
                ITopographyPlayerData data = (ITopographyPlayerData)event.getEntity().getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                if (data != null && (data.getIslandX() != 0 || data.getIslandZ() != 0)) {
                    BlockPos pos = new BlockPos(data.getIslandX(), 0, data.getIslandZ());
                    BlockPos topBlock = IslandNew.getTopSolidOrLiquidBlock((World)world, pos);
                    event.setCanceled(true);
                    this.teleporting = true;
                    event.getEntity().changeDimension(event.getDimension(), (ITeleporter)new ReTeleporter(topBlock.func_177984_a()));
                    this.teleporting = false;
                    return;
                }
                Iterator<Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>>> iterator = islandGenerator.getIslandPositions(world.func_72905_C(), 0, 0).entrySet().iterator();
                if (!iterator.hasNext() || !(positions = (islands = iterator.next()).getValue().entrySet().iterator()).hasNext()) break;
                Map.Entry<BlockPos, SkyIslandType> island = positions.next();
                BlockPos pos = island.getKey();
                BlockPos topBlock = IslandNew.getTopSolidOrLiquidBlock((World)world, pos);
                event.setCanceled(true);
                this.teleporting = true;
                event.getEntity().changeDimension(event.getDimension(), (ITeleporter)new ReTeleporter(topBlock.func_177984_a()));
                this.teleporting = false;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(TopographyPlayerData.Provider.location, (ICapabilityProvider)new TopographyPlayerData.Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && event.getOriginal().field_70128_L) {
            ITopographyPlayerData orgData = (ITopographyPlayerData)event.getOriginal().getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
            ITopographyPlayerData newData = (ITopographyPlayerData)event.getEntityPlayer().getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
            newData.setIsland(orgData.getIslandX(), orgData.getIslandZ());
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(new BlockPortal(){

            public boolean func_176548_d(World world, BlockPos pos) {
                DimensionDefinition dimensionDef;
                ConfigPreset preset;
                ConfigurationManager manager = ConfigurationManager.getInstance();
                if (manager != null && (preset = manager.getPreset()) != null && (dimensionDef = preset.getDefinition(world.field_73011_w.getDimension())) != null && (dimensionDef.shouldDisableNetherPortal() || ConfigurationManager.getInstance().getPreset().shouldDisableNetherPortal())) {
                    return false;
                }
                return super.func_176548_d(world, pos);
            }
        }.setRegistryName("minecraft:portal"));
    }

    public static class ReTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        public ReTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_174828_a(this.targetPos, yaw, entity.field_70125_A);
        }
    }
}

