/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world;

import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.world.decorator.DecoratorScattered;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class SkyIslandDataHandler {
    private final List<SkyIslandData> skyIslandData = new ArrayList<SkyIslandData>();
    private Map<SkyIslandData, Map<BlockPos, SkyIslandType>> islandPositions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
    private final Random islandPositionRandom = new Random();
    private double regionSize = 464.0;
    private int currentRegionX = -100000000;
    private int currentRegionZ = -100000000;
    public static final Map<String, Class> classKeywords = new HashMap<String, Class>();

    private void generateIslandPositions(long worldSeed) {
        this.islandPositionRandom.setSeed((long)this.currentRegionX * 341873128712L + (long)this.currentRegionZ * 132897987541L + worldSeed);
        this.islandPositions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
        for (SkyIslandData data : this.skyIslandData) {
            int genCount = 0;
            block1: for (int i = 0; i < data.getCount() || genCount < data.getMinCount(); ++i) {
                Map<BlockPos, SkyIslandType> positions;
                double maxFeatureRadius = data.getRadius();
                double midHeight = maxFeatureRadius + (double)this.islandPositionRandom.nextInt((int)(220.0 - maxFeatureRadius * 2.0));
                int regionCenterX = (int)((double)this.currentRegionX * this.regionSize + this.regionSize / 2.0);
                int regionCenterZ = (int)((double)this.currentRegionZ * this.regionSize + this.regionSize / 2.0);
                int randomSpace = (int)(this.regionSize - maxFeatureRadius * 2.0);
                int featureCenterX = this.islandPositionRandom.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
                int featureCenterZ = this.islandPositionRandom.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
                BlockPos pos = new BlockPos((double)featureCenterX, midHeight, (double)featureCenterZ);
                for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.islandPositions.entrySet()) {
                    double minDistance = (double)set.getKey().getRadius() + maxFeatureRadius + 25.0;
                    for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                        if (!(SkyIslandDataHandler.getDistance(pos, islandPos.getKey()) < minDistance)) continue;
                        continue block1;
                    }
                }
                if (!this.islandPositions.containsKey(data)) {
                    this.islandPositions.put(data, new LinkedHashMap());
                }
                if (data.isRandomIslands()) {
                    positions = this.islandPositions.get(data);
                    positions.put(pos, data.getType(this.islandPositionRandom.nextInt(128)));
                } else {
                    positions = this.islandPositions.get(data);
                    positions.put(pos, data.getType(genCount));
                }
                ++genCount;
            }
        }
    }

    public Map<SkyIslandData, Map<BlockPos, SkyIslandType>> getIslandPositions(long worldSeed, int x, int z) {
        if ((int)Math.floor(Math.floor((double)x / 16.0) * 16.0 / this.regionSize) != this.currentRegionX || (int)Math.floor(Math.floor((double)z / 16.0) * 16.0 / this.regionSize) != this.currentRegionZ) {
            this.currentRegionX = (int)Math.floor(Math.floor((double)x / 16.0) * 16.0 / this.regionSize);
            this.currentRegionZ = (int)Math.floor(Math.floor((double)z / 16.0) * 16.0 / this.regionSize);
            this.generateIslandPositions(worldSeed);
        }
        return this.islandPositions;
    }

    public static double getDistance(BlockPos pos, BlockPos pos2) {
        double d0 = pos.func_177958_n() - pos2.func_177958_n();
        double d2 = pos.func_177952_p() - pos2.func_177952_p();
        return Math.sqrt(d0 * d0 + d2 * d2);
    }

    public double getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(int size) {
        this.regionSize = size * 16;
    }

    public SkyIslandData addSkyIslands(int radius, int count, boolean randomTypes) {
        SkyIslandData data = new SkyIslandData();
        data.setRadius(radius);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        this.skyIslandData.add(data);
        return data;
    }

    static {
        classKeywords.put("SkyIslandType", SkyIslandType.class);
        classKeywords.put("DecoratorScattered", DecoratorScattered.class);
    }
}

