/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world;

import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.client.renderer.CloudRendererDisabled;
import com.bloodnbonesgaming.topography.client.renderer.SkyRendererCustom;
import com.bloodnbonesgaming.topography.client.renderer.SkyRendererDisabled;
import com.bloodnbonesgaming.topography.client.renderer.TopographyWeatherRenderer;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderConfigurable
extends WorldProvider {
    private DimensionType type;
    private DimensionDefinition definition;

    public DimensionType func_186058_p() {
        return this.type;
    }

    protected void func_76572_b() {
        this.type = DimensionManager.getProviderType((int)this.getDimension());
        this.field_191067_f = true;
        Topography.instance.getLog().info((Object)("GenSettings: " + this.field_82913_c));
        ConfigPreset preset = ConfigurationManager.getInstance().getPreset();
        this.field_82913_c = preset.getName();
        Topography.instance.getLog().info((Object)("Preset: " + preset.getName()));
        if (preset != null) {
            this.definition = preset.getDefinition(this.getDimension());
            this.field_76578_c = this.definition.getBiomeProvider(this.field_76579_a);
            this.field_191067_f = this.definition.skylight();
            this.field_76575_d = this.definition.shouldVaporieWater();
            if (this.field_76579_a.field_72995_K) {
                if (!this.definition.renderSky()) {
                    this.setSkyRenderer(SkyRendererDisabled.instance);
                    TopographyWeatherRenderer weather = this.definition.getWeatherRenderer();
                    if (weather != null) {
                        this.setWeatherRenderer(weather);
                    }
                } else {
                    TopographyWeatherRenderer weather;
                    SkyRendererCustom renderer = this.definition.getSkyRenderer();
                    if (renderer != null) {
                        this.setSkyRenderer(renderer);
                    }
                    if ((weather = this.definition.getWeatherRenderer()) != null) {
                        this.setWeatherRenderer(weather);
                    }
                }
            }
        }
    }

    public DimensionDefinition getDefinition() {
        return this.definition;
    }

    public IChunkGenerator func_186060_c() {
        return this.definition.getChunkGenerator(this.field_76579_a);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float p_76562_2_) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    public boolean func_76568_b(int x, int z) {
        return this.definition.renderEnviromentalFog();
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        Float angle = this.definition.getCelestialAngle();
        if (angle != null) {
            return angle.floatValue();
        }
        return super.func_76563_a(worldTime, partialTicks);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (!this.definition.renderClouds()) {
            return CloudRendererDisabled.instance;
        }
        return super.getCloudRenderer();
    }

    protected void func_76556_a() {
        float[] table = this.definition.getLightBrightnessTable();
        if (table != null) {
            for (int i = 0; i <= 15; ++i) {
                this.field_76573_f[i] = table[i];
            }
        } else {
            super.func_76556_a();
        }
    }

    public boolean shouldClientCheckLighting() {
        return this.definition.resetRelightChecks();
    }

    public boolean func_76567_e() {
        return this.definition.canRespawn();
    }

    public BlockPos func_177496_h() {
        if (this.getDimension() == 1) {
            return new BlockPos(100, 50, 0);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        float height = this.definition.getCloudHeight();
        if (height != -999.0f) {
            return height;
        }
        return super.func_76571_f();
    }

    public boolean func_186056_c(int x, int z) {
        return !this.field_76579_a.field_73011_w.func_186058_p().shouldLoadSpawn() || !this.field_76579_a.func_72916_c(x, z);
    }
}

