/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.biome.provider.layers.BiomeData;
import com.bloodnbonesgaming.topography.world.biome.provider.layers.BiomeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation//biome_providers//genlayers/GenLayerHeatToBiomes", classExplaination="A more configurable version of GenLayerBiomeDC. Replaces the heat map with a pseudo-random weighted biome map. For the vanilla heat map, normally 1 is desert, 2 is warm, 3 is cool, 4 is icy.")
public class GenLayerHeatToBiomes
extends GenLayer {
    private List<BiomeData> biomeDataList = new ArrayList<BiomeData>();
    private int specialVariantChance = 3;

    @ScriptMethodDocumentation(args="long, GenLayer", usage="base layer seed, parent", notes="Constructs the layer with the seed and parent.")
    public GenLayerHeatToBiomes(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    private BiomeData getBiomeData(int id) {
        while (this.biomeDataList.size() <= id) {
            BiomeData data = new BiomeData();
            data.setSpecialVariantChance(this.specialVariantChance);
            this.biomeDataList.add(data);
        }
        return this.biomeDataList.get(id);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="heat ID, biome ID", notes="Adds the provided biome id to the provided heat id with a weight of 1. What heat ids are available depends on the GenLayer used before this")
    public void addBiome(int heat, int id) {
        this.addBiome(heat, id, 1);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID, ArgType.INT})
    @ScriptMethodDocumentation(usage="heat ID, biome ID, weight", notes="Adds the provided biome id to the provided heat id with the provided weight. What heat ids are available depends on the GenLayer used before this.")
    public void addBiome(int heat, int id, int weight) {
        BiomeData data = this.getBiomeData(heat);
        BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
        if (entry != null) {
            data.addBiomeEntry(entry);
        }
    }

    @ScriptMethodDocumentation(args="int", usage="chance", notes="Sets the global chance for the special variant biome to be used. This will set the chance for all heat ids. Set this before you set specific ones or it will overwrite. The chance is 1 in the provided number.")
    public void setSpecialVariantChance(int chance) {
        this.specialVariantChance = chance;
        for (BiomeData data : this.biomeDataList) {
            data.setSpecialVariantChance(chance);
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.INT})
    @ScriptMethodDocumentation(usage="heat ID, chance", notes="Sets the chance for the special variant biome to be used for the provided heat id. The chance is 1 in the provided number. What heat ids are available depends on the GenLayer used before this.")
    public void setSpecialVariantChance(int heat, int chance) {
        this.getBiomeData(heat).setSpecialVariantChance(chance);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="heat ID, biome ID", notes="Sets the special biome for the provided heat id. What heat ids are available depends on the GenLayer used before this.")
    public void setSpecialBiome(int heat, int biome) {
        this.getBiomeData(heat).setSpecial(biome);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="heat ID, biome ID", notes="Sets the special variant biome for the provided heat id. What heat ids are available depends on the GenLayer used before this.")
    public void setSpecialVariantBiome(int heat, int biome) {
        this.getBiomeData(heat).setSpecialVariant(biome);
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int arrayLength = width * depth;
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX, chunkZ, width, depth);
        int[] returnInts = IntCache.func_76445_a((int)arrayLength);
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                boolean useSpecialBiome;
                this.func_75903_a(x + chunkX, z + chunkZ);
                int index = x + z * width;
                int currentBiome = parentInts[index];
                boolean bl = useSpecialBiome = (currentBiome & 0xF00) >> 8 > 0;
                if (currentBiome < this.biomeDataList.size()) {
                    BiomeData data = this.biomeDataList.get(currentBiome);
                    if (data == null) continue;
                    if (useSpecialBiome) {
                        if (data.getSpecialVariant() != null && this.func_75902_a(data.getSpecialVariantChance()) == 0) {
                            returnInts[index] = data.getSpecialVariant();
                            continue;
                        }
                        if (data.getSpecial() != null) {
                            returnInts[index] = data.getSpecial();
                            continue;
                        }
                    }
                    if (data.getBiomes().size() > 0) {
                        returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(data.getBiomes()).biome);
                        continue;
                    }
                    returnInts[index] = 0;
                    continue;
                }
                returnInts[index] = parentInts[index];
            }
        }
        return returnInts;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(List<BiomeManager.BiomeEntry> biomeList) {
        boolean modded = false;
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = modded ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

