/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation//biome_providers//genlayers/GenLayerReplaceAll", classExplaination="A layer for replacing all biomes with a single biome.")
public class GenLayerReplaceAll
extends GenLayer {
    private int replacement;

    @ScriptMethodDocumentation(args="long, GenLayer", usage="base layer seed, parent layer", notes="Constructs the layer with its base seed and parent layer.")
    public GenLayerReplaceAll(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    @ScriptArgs(args={ArgType.LONG, ArgType.GENLAYER, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="base layer seed, parent layer", notes="Constructs the layer with its base seed and parent layer and sets the replacement biome.")
    public GenLayerReplaceAll(long seed, GenLayer parent, int replacement) {
        this(seed, parent);
        this.replacement = replacement;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="Sets the biome this layer will replace all biomes with")
    public void setReplacement(int biome) {
        this.replacement = biome;
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                returnInts[x + z * width] = this.replacement;
            }
        }
        return returnInts;
    }
}

