/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.decorator;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.world.SkyIslandDataHandler;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;

public class DecoratorScattered {
    private final IBlockState decoration;
    private final Random rand = new Random();

    public DecoratorScattered(ItemBlockData data) throws Exception {
        this.decoration = data.buildBlockState();
    }

    public void generateForSkyIsland(int count, long seed, int chunkX, int chunkZ, ChunkPrimer primer, BlockPos center, SkyIslandData data, SkyIslandType type, SkyIslandGenerator generator, int regionSize) {
        int radius = data.getRadius();
        int regionStartX = (int)(Math.floor((double)chunkX * 16.0 / (double)regionSize) * (double)regionSize);
        int regionStartZ = (int)(Math.floor((double)chunkZ * 16.0 / (double)regionSize) * (double)regionSize);
        this.rand.setSeed((long)Math.floor((double)chunkX * 16.0 / (double)regionSize) * 341873128712L + (long)Math.floor((double)chunkZ * 16.0 / (double)regionSize) * 132897987541L + seed + (long)center.func_177958_n() * 25565L + (long)center.func_177952_p() * 35754L);
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = 0; i < count; ++i) {
            int xPos = this.rand.nextInt(regionSize);
            int zPos = this.rand.nextInt(regionSize);
            BlockPos pos = new BlockPos(xPos + regionStartX, 0, zPos + regionStartZ);
            int chunkMinX = chunkX * 16;
            int chunkMinZ = chunkZ * 16;
            int chunkMaxX = chunkX * 16 + 16;
            int chunkMaxZ = chunkZ * 16 + 16;
            if (pos.func_177958_n() < chunkMinX || pos.func_177958_n() >= chunkMaxX || pos.func_177952_p() < chunkMinZ || pos.func_177952_p() >= chunkMaxZ || !(SkyIslandDataHandler.getDistance(pos, center) <= (double)radius) || posList.contains(pos)) continue;
            int inChunkX = pos.func_177958_n() - chunkMinX;
            int inChunkZ = pos.func_177952_p() - chunkMinZ;
            posList.add(pos);
            int y = this.getTopSolidBlock(primer, inChunkX, inChunkZ);
            if (y < center.func_177956_o()) continue;
            primer.func_177855_a(inChunkX, y + 1, inChunkZ, this.decoration);
        }
    }

    private final int getTopSolidBlock(ChunkPrimer primer, int x, int z) {
        for (int y = 255; y > 0; --y) {
            IBlockState state = primer.func_177856_a(x, y, z);
            if (!state.func_185896_q()) continue;
            return y;
        }
        return 0;
    }
}

