/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.NumberHelper;
import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/DeformedSphereGenerator", classExplaination="This file is for the DeformedSphereGenerator. This generator generates spheres of blocks, which are then deformed using simplex noise. These spheres generate within grid regions, and can therefore be any size. ")
public class DeformedSphereGenerator
implements IGenerator {
    final IBlockState state;
    final int regionSize;
    final int radius;
    final int count;
    final int minCount;
    double deformScale = 16.0;
    boolean populate = false;
    private final List<BlockPredicate> requiredBlocks = new ArrayList<BlockPredicate>();
    protected OpenSimplexNoiseGeneratorOctaves terrainNoise;
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];
    double[] smallDeformNoiseArray = new double[825];
    double[] largeDeformNoiseArray = new double[65536];

    @ScriptMethodDocumentation(args="ItemBlockData, int, int, int, int", usage="block to generate, grid region size in chunks, radius, generation attempt count, minimum sphere count", notes="This constructs a DeformedSphereGenerator.")
    public DeformedSphereGenerator(ItemBlockData data, int regionSize, int radius, int count, int minCount) throws Exception {
        this.state = data.buildBlockState();
        this.regionSize = regionSize * 16;
        this.radius = radius;
        this.count = count;
        this.minCount = minCount;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="required block", notes="Adds a block the generator is allowed to generate a sphere within. By default can generate within block.")
    public void addRequiredBlock(ItemBlockData data) throws Exception {
        this.requiredBlocks.add(data.buildBlockPredicate());
    }

    @ScriptMethodDocumentation(args="double", usage="scale", notes="Sets the noise scale used to deform the spheres. Default is 16.0. The higher the number, the more the sphere can be deformed.")
    public void setDeformScale(double scale) {
        this.deformScale = scale;
    }

    public void populate() {
        this.populate = true;
    }

    private void generateNoise(int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    this.smallNoiseArray[index] = this.terrainNoise.eval((double)(x + xI * xCoordinateScale) / 16.0, (double)(y + yI * yCoordinateScale) / 16.0, (double)(z + zI * zCoordinateScale) / 16.0, 3, 0.75);
                    this.smallDeformNoiseArray[index] = this.terrainNoise.eval((double)(x + xI * xCoordinateScale) / this.deformScale, (double)(y + yI * yCoordinateScale) / this.deformScale, (double)(z + zI * zCoordinateScale) / this.deformScale, 3, 0.75);
                }
            }
        }
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        if (this.populate) {
            return;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        long seed = world.func_72905_C();
        this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(seed);
        this.generateNoise(5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
        NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        NumberHelper.interpolate((double[])this.smallDeformNoiseArray, (double[])this.largeDeformNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        int regionX = (int)Math.floor((double)chunkX * 16.0 / (double)this.regionSize);
        int regionZ = (int)Math.floor((double)chunkZ * 16.0 / (double)this.regionSize);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int genCount = 0;
        block0: for (int i = 0; i < this.count || genCount < this.minCount; ++i) {
            double maxFeatureRadius = this.radius;
            double midHeight = maxFeatureRadius + (double)random.nextInt((int)(256.0 - maxFeatureRadius * 2.0));
            int regionCenterX = regionX * this.regionSize + this.regionSize / 2;
            int regionCenterZ = regionZ * this.regionSize + this.regionSize / 2;
            int randomSpace = (int)((double)this.regionSize - maxFeatureRadius * 2.0);
            int featureCenterX = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
            int featureCenterZ = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
            mutable.func_189532_c((double)featureCenterX, midHeight, (double)featureCenterZ);
            for (BlockPos position : positions) {
                double minDistance = (double)this.radius + maxFeatureRadius;
                if (!(this.Distance3D((BlockPos)mutable, position) < minDistance * minDistance)) continue;
                continue block0;
            }
            positions.add(mutable.func_185334_h());
            ++genCount;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    double noise = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                    double deformNoise = this.largeDeformNoiseArray[(x * 16 + z) * 256 + y];
                    if (!(noise > 0.5)) continue;
                    for (BlockPos center : positions) {
                        int inChunkZ;
                        int inChunkX;
                        int chunkMinX = chunkX * 16;
                        int chunkMinZ = chunkZ * 16;
                        int chunkMaxX = chunkX * 16 + 16;
                        int chunkMaxZ = chunkZ * 16 + 16;
                        mutable.func_181079_c(chunkMinX + x, y, chunkMinZ + z);
                        if (!(this.Distance3D((BlockPos)mutable, center) <= (double)(this.radius * this.radius) * deformNoise) || !this.isBlockAcceptable(primer.func_177856_a(inChunkX = mutable.func_177958_n() - chunkMinX, y, inChunkZ = mutable.func_177952_p() - chunkMinZ))) continue;
                        primer.func_177855_a(inChunkX, y, inChunkZ, this.state);
                    }
                }
            }
        }
    }

    private boolean isBlockAcceptable(World world, BlockPos pos) {
        return this.requiredBlocks.isEmpty() || this.isBlockAcceptable(world.func_180495_p(pos));
    }

    private boolean isBlockAcceptable(IBlockState state) {
        if (this.requiredBlocks.isEmpty()) {
            return true;
        }
        for (BlockPredicate predicate : this.requiredBlocks) {
            if (!predicate.test(state)) continue;
            return true;
        }
        return false;
    }

    public double Distance3D(BlockPos pos, BlockPos pos2) {
        double d0 = pos.func_177958_n() - pos2.func_177958_n();
        double d1 = pos.func_177956_o() - pos2.func_177956_o();
        double d2 = pos.func_177952_p() - pos2.func_177952_p();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random random) {
        if (this.populate) {
            long seed = world.func_72905_C();
            this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(seed);
            this.generateNoise(5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
            NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
            NumberHelper.interpolate((double[])this.smallDeformNoiseArray, (double[])this.largeDeformNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
            int regionX = (int)Math.floor((double)chunkX * 16.0 / (double)this.regionSize);
            int regionZ = (int)Math.floor((double)chunkZ * 16.0 / (double)this.regionSize);
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            int genCount = 0;
            block0: for (int i = 0; i < this.count || genCount < this.minCount; ++i) {
                double maxFeatureRadius = this.radius;
                double midHeight = maxFeatureRadius + (double)random.nextInt((int)(256.0 - maxFeatureRadius * 2.0));
                int regionCenterX = regionX * this.regionSize + this.regionSize / 2;
                int regionCenterZ = regionZ * this.regionSize + this.regionSize / 2;
                int randomSpace = (int)((double)this.regionSize - maxFeatureRadius * 2.0);
                int featureCenterX = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
                int featureCenterZ = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
                BlockPos pos = new BlockPos((double)featureCenterX, midHeight, (double)featureCenterZ);
                for (BlockPos position : positions) {
                    double minDistance = (double)this.radius + maxFeatureRadius;
                    if (!(this.Distance3D(pos, position) < minDistance)) continue;
                    continue block0;
                }
                positions.add(pos);
                ++genCount;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        for (BlockPos center : positions) {
                            int chunkMinX = chunkX * 16;
                            int chunkMinZ = chunkZ * 16;
                            int chunkMaxX = chunkX * 16 + 16;
                            int chunkMaxZ = chunkZ * 16 + 16;
                            BlockPos pos = new BlockPos(chunkMinX + x + 2, y, chunkMinZ + z + 2);
                            double noise = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                            double deformNoise = this.largeNoiseArray[(x * 16 + z) * 256 + y] * 0.75 + 0.25;
                            if (!(noise > 0.5) || !(this.Distance3D(pos, center) <= (double)this.radius * deformNoise) || world.func_180495_p(pos) != Blocks.field_150424_aL.func_176223_P()) continue;
                            world.func_175656_a(pos, this.state);
                        }
                    }
                }
            }
        }
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }

    @Override
    public int getRegionSize() {
        return this.regionSize;
    }
}

