/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/LayerGenerator", classExplaination="This file is for the LayerGenerator. This generator can be created in a dimension file with 'new LayerGenerator()'.")
public class LayerGenerator
implements IGenerator {
    private final Map<MinMaxBounds, Map<IBlockState, BlockPredicate>> layers = new LinkedHashMap<MinMaxBounds, Map<IBlockState, BlockPredicate>>();

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        for (int y = 0; y < 256; ++y) {
            for (Map.Entry<MinMaxBounds, Map<IBlockState, BlockPredicate>> entry : this.layers.entrySet()) {
                for (Map.Entry<IBlockState, BlockPredicate> inner : entry.getValue().entrySet()) {
                    if (!entry.getKey().func_192514_a((float)y)) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            BlockPredicate predicate = inner.getValue();
                            if (predicate != null && predicate != BlockPredicate.ANY && !predicate.test(primer.func_177856_a(x, y, z))) continue;
                            primer.func_177855_a(x, y, z, inner.getKey());
                        }
                    }
                }
            }
        }
    }

    @ScriptMethodDocumentation(args="MinMaxBounds, ItemBlockData", usage="y axis bounds, block to place", notes="Adds a layer of blocks to be generated within the provided bounds, made of the provided block.")
    public void addLayer(MinMaxBounds bounds, ItemBlockData block) throws Exception {
        LinkedHashMap<IBlockState, Object> whitelist = new LinkedHashMap<IBlockState, Object>();
        whitelist.put(block.buildBlockState(), null);
        this.layers.put(bounds, whitelist);
    }

    @ScriptMethodDocumentation(args="MinMaxBounds, ItemBlockData, ItemBlockData", usage="y axis bounds, block to place, block to replace", notes="Adds a layer of blocks to be generated within the provided bounds, made of the provided block, replacing only the provided block.")
    public void addLayer(MinMaxBounds bounds, ItemBlockData block, ItemBlockData toReplace) throws Exception {
        LinkedHashMap<IBlockState, BlockPredicate> whitelist = new LinkedHashMap<IBlockState, BlockPredicate>();
        whitelist.put(block.buildBlockState(), toReplace.buildBlockPredicate());
        this.layers.put(bounds, whitelist);
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }
}

