/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class SimplexNoiseGenerator
implements IGenerator {
    private OpenSimplexNoiseGeneratorOctaves noise;
    private double xScale = 128.0;
    private double yScale = 32.0;
    private double zScale = 128.0;
    private int octaves = 3;
    private double persistence = 0.5;
    private double cutoff = 0.5;
    private IBlockState state;
    private int minHeight = 0;
    private int maxHeight = 256;

    public SimplexNoiseGenerator(ItemBlockData data) throws Exception {
        this.state = data.buildBlockState();
    }

    public void setScale(double xScale, double yScale, double zScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    public void setOctaves(int octaves) {
        this.octaves = octaves;
    }

    public void setPersistence(double persistence) {
        this.persistence = persistence;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    public void setHeight(int minHeight, int maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        if (this.noise == null) {
            this.noise = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = this.minHeight; y < this.maxHeight; ++y) {
                    double value = this.noise.eval((double)(chunkX * 16 + x) / this.xScale, (double)y / this.yScale, (double)(chunkZ * 16 + z) / this.zScale, this.octaves, this.persistence);
                    if (y < 20) {
                        value += (double)(20 - y) * 0.05;
                    } else if (this.maxHeight - y < 20) {
                        value += (double)(20 - (this.maxHeight - y)) * 0.05;
                    }
                    if (!(value > this.cutoff)) continue;
                    primer.func_177855_a(x, y, z, this.state);
                }
            }
        }
    }
}

