/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.AACHackInfo;
import com.djrapitops.extension.AACHackKickListener;
import com.djrapitops.extension.AACStorage;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.text.SimpleDateFormat;
import java.util.UUID;

@PluginInfo(name="AdvancedAntiCheat", iconName="heart", iconFamily=Family.SOLID, color=Color.RED)
public class AACExtension
implements DataExtension {
    private AACStorage storage;

    public AACExtension() {
        this.storage = new AACStorage();
        new AACHackKickListener(this.storage).register();
    }

    AACExtension(boolean forTesting) {
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE};
    }

    @NumberProvider(text="Kicked for Hacking", description="Times Kicked for Possible Hacking, also includes false positives", iconName="exclamation-triangle", iconColor=Color.RED, showInPlayerTable=true)
    public long timesKickedForHack(UUID playerUUID) {
        return this.storage.getHackKickCount(playerUUID);
    }

    @TableProvider(tableColor=Color.RED)
    public Table hackKickTable(UUID playerUUID) {
        Table.Factory table = Table.builder().columnOne("Kicked", Icon.called("calendar").of(Family.REGULAR).build()).columnTwo("Hack", Icon.called("exclamation-triangle").build()).columnThree("Violation Level", Icon.called("gavel").build());
        SimpleDateFormat format = new SimpleDateFormat("MMM d YYYY, HH:mm");
        for (AACHackInfo hack : this.storage.getHackInformation(playerUUID)) {
            table.addRow(format.format(hack.getDate()), hack.getHackType(), hack.getViolationLevel());
        }
        return table.build();
    }
}

