/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.AACHackInfo;
import com.djrapitops.extension.AACStorage;
import java.util.UUID;
import me.konsolas.aac.api.AACAPIProvider;
import me.konsolas.aac.api.HackType;
import me.konsolas.aac.api.PlayerViolationCommandEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class AACHackKickListener
implements Listener {
    private final AACStorage storage;
    private final Plugin plugin;

    AACHackKickListener(AACStorage storage) {
        this.storage = storage;
        this.plugin = Bukkit.getPluginManager().getPlugin("Plan");
    }

    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(PlayerViolationCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        HackType hackType = event.getHackType();
        String hackTypeName = hackType.getName();
        long time = System.currentTimeMillis();
        int violations = AACAPIProvider.getAPI().getViolationLevel(player, hackType);
        AACHackInfo hack = new AACHackInfo(uuid, time, hackTypeName, violations);
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> this.storage.storeHackKickInformation(uuid, hack));
    }
}

