/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.AACHackInfo;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.query.CommonQueries;
import com.djrapitops.plan.query.QueryService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AACStorage {
    private final QueryService queryService = QueryService.getInstance();

    public AACStorage() {
        this.createTable();
        this.queryService.subscribeDataClearEvent(this::recreateTable);
        this.queryService.subscribeToPlayerRemoveEvent(this::removePlayer);
    }

    private void createTable() {
        String dbType = this.queryService.getDBType();
        boolean sqlite = dbType.equalsIgnoreCase("SQLITE");
        this.patchTable(sqlite);
        String sql = "CREATE TABLE IF NOT EXISTS plan_aac_hack_table (id int " + (sqlite ? "PRIMARY KEY" : "NOT NULL AUTO_INCREMENT") + ',' + "uuid varchar(36) NOT NULL,server_uuid varchar(36) NOT NULL,date bigint NOT NULL,hack_type varchar(100) NOT NULL,violation_level int NOT NULL" + (sqlite ? "" : ",PRIMARY KEY (id)") + ')';
        this.queryService.execute(sql, PreparedStatement::execute);
    }

    private void patchTable(boolean sqlite) {
        CommonQueries commonQueries = this.queryService.getCommonQueries();
        if (commonQueries.doesDBHaveTable("plan_aac_hack_table")) {
            if (!commonQueries.doesDBHaveTableColumn("plan_aac_hack_table", "server_uuid")) {
                UUID serverUUID = this.queryService.getServerUUID().orElseThrow(IllegalStateException::new);
                this.queryService.execute("ALTER TABLE plan_aac_hack_table ADD " + (sqlite ? "COLUMN " : "") + "server_uuid varchar(36) NOT NULL DEFAULT '" + serverUUID.toString() + "'", PreparedStatement::execute);
            }
            if (!commonQueries.doesDBHaveTableColumn("plan_aac_hack_table", "date")) {
                this.queryService.execute("ALTER TABLE plan_aac_hack_table ADD " + (sqlite ? "COLUMN " : "") + "date bigint NOT NULL DEFAULT 0", PreparedStatement::execute);
            }
        }
    }

    private void dropTable() {
        this.queryService.execute("DROP TABLE IF EXISTS plan_aac_hack_table", PreparedStatement::execute);
    }

    private void recreateTable() {
        this.dropTable();
        this.createTable();
    }

    private void removePlayer(UUID playerUUID) {
        this.queryService.execute("DELETE FROM plan_aac_hack_table WHERE uuid=?", statement -> {
            statement.setString(1, playerUUID.toString());
            statement.execute();
        });
    }

    public void storeHackKickInformation(UUID playerUUID, AACHackInfo info) {
        String insert = "INSERT INTO plan_aac_hack_table (uuid, server_uuid, date, hack_type, violation_level) VALUES (?, ?, ?, ?, ?)";
        UUID serverUUID = this.queryService.getServerUUID().orElseThrow(IllegalStateException::new);
        this.queryService.execute(insert, statement -> {
            statement.setString(1, info.getUuid().toString());
            statement.setString(2, serverUUID.toString());
            statement.setLong(3, info.getDate());
            statement.setString(4, info.getHackType());
            statement.setInt(5, info.getViolationLevel());
            statement.execute();
        });
    }

    public List<AACHackInfo> getHackInformation(UUID playerUUID) {
        String sql = "SELECT * FROM plan_aac_hack_table WHERE uuid=? AND server_uuid=? ORDER BY date DESC";
        UUID serverUUID = this.queryService.getServerUUID().orElseThrow(NotReadyException::new);
        return this.queryService.query(sql, statement -> {
            statement.setString(1, playerUUID.toString());
            statement.setString(2, serverUUID.toString());
            ArrayList<AACHackInfo> hackInfos = new ArrayList<AACHackInfo>();
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    long date = set.getLong("date");
                    String hackType = set.getString("hack_type");
                    int violationLevel = set.getInt("violation_level");
                    hackInfos.add(new AACHackInfo(playerUUID, date, hackType, violationLevel));
                }
                ArrayList<AACHackInfo> arrayList = hackInfos;
                return arrayList;
            }
        });
    }

    public int getHackKickCount(UUID playerUUID) {
        UUID serverUUID = this.queryService.getServerUUID().orElseThrow(NotReadyException::new);
        String sql = "SELECT COUNT(1) as count FROM plan_aac_hack_table WHERE uuid=? AND server_uuid=?";
        return this.queryService.query("SELECT COUNT(1) as count FROM plan_aac_hack_table WHERE uuid=? AND server_uuid=?", statement -> {
            statement.setString(1, playerUUID.toString());
            statement.setString(2, serverUUID.toString());
            try (ResultSet set = statement.executeQuery();){
                Integer n = set.next() ? set.getInt("count") : 0;
                return n;
            }
        });
    }
}

