/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PercentageProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TabOrder;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import com.wasteofplastic.askyblock.ASkyBlockAPI;
import java.util.Map;
import java.util.UUID;

@PluginInfo(name="ASkyBlock", iconName="street-view", iconFamily=Family.SOLID, color=Color.LIGHT_BLUE)
@TabInfo.Multiple(value={@TabInfo(tab="Islands", iconName="street-view", elementOrder={ElementOrder.VALUES}), @TabInfo(tab="Challenges", iconName="bookmark", elementOrder={ElementOrder.VALUES})})
@TabOrder(value={"Islands", "Challenges"})
public class ASkyBlockExtension
implements DataExtension {
    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @BooleanProvider(text="Has Island", description="Does the player have a skyblock island", conditionName="hasIsland", iconName="street-view", iconColor=Color.GREEN, priority=100)
    @Tab(value="Islands")
    public boolean hasIsland(UUID playerUUID) {
        return ASkyBlockAPI.getInstance().hasIsland(playerUUID);
    }

    @Conditional(value="hasIsland")
    @StringProvider(text="Island name", description="Name of the player's island", iconName="street-view", iconColor=Color.GREEN, priority=99, showInPlayerTable=true)
    @Tab(value="Islands")
    public String islandName(UUID playerUUID) {
        String name = ASkyBlockAPI.getInstance().getIslandName(playerUUID);
        return name != null ? name : "-";
    }

    @Conditional(value="hasIsland")
    @NumberProvider(text="Island level", description="Level of the player's island", iconName="street-view", iconColor=Color.AMBER, priority=98)
    @Tab(value="Islands")
    public long islandLevel(UUID playerUUID) {
        return ASkyBlockAPI.getInstance().getLongIslandLevel(playerUUID);
    }

    @Conditional(value="hasIsland")
    @NumberProvider(text="Island Resets Left", description="How many times can the player reset their island", iconName="street-view", iconColor=Color.GREEN, priority=97)
    @Tab(value="Islands")
    public long islandResets(UUID playerUUID) {
        return ASkyBlockAPI.getInstance().getResetsLeft(playerUUID);
    }

    @NumberProvider(text="Completed Challenges", description="How many challenges has the player completed", iconName="bookmark", iconColor=Color.GREEN, priority=100, showInPlayerTable=true)
    @Tab(value="Challenges")
    public long challengesCompleted(UUID playerUUID) {
        return ASkyBlockAPI.getInstance().getChallengeStatus(playerUUID).values().stream().filter(value -> value).count();
    }

    @PercentageProvider(text="Progress", description="% out of total challenges completed", iconName="bookmark", iconColor=Color.GREEN, priority=99)
    @Tab(value="Challenges")
    public double challengeProgress(UUID playerUUID) {
        Map challengeStatus = ASkyBlockAPI.getInstance().getChallengeStatus(playerUUID);
        double max = challengeStatus.size();
        return (double)challengeStatus.values().stream().filter(value -> value).count() * 1.0 / max;
    }

    @TableProvider(tableColor=Color.LIGHT_BLUE)
    @Tab(value="Challenges")
    public Table completedChallenges(UUID playerUUID) {
        Map challengeTimes = ASkyBlockAPI.getInstance().getChallengeTimes(playerUUID);
        Table.Factory table = Table.builder().columnOne("Challenge", Icon.called("bookmark").build()).columnTwo("Times completed", Icon.called("check").build());
        challengeTimes.entrySet().stream().sorted((one, two) -> Integer.compare((Integer)two.getValue(), (Integer)one.getValue())).forEach(entry -> {
            String challenge = ((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).substring(1).toLowerCase();
            Integer completionTimes = (Integer)entry.getValue();
            boolean complete = completionTimes > 0;
            table.addRow("<span" + (complete ? " class=\"col-green\"" : "") + ">" + challenge + "</span>", completionTimes);
        });
        return table.build();
    }

    @StringProvider(text="Island World", description="What world is used for ASkyBlock islands", priority=102, iconName="map", iconColor=Color.GREEN, iconFamily=Family.REGULAR)
    @Tab(value="Islands")
    public String islandWorld() {
        return ASkyBlockAPI.getInstance().getIslandWorld().getName();
    }

    @NumberProvider(text="Island Count", description="How many islands exist", priority=101, iconName="street-view", iconColor=Color.GREEN)
    @Tab(value="Islands")
    public long islandCount() {
        return ASkyBlockAPI.getInstance().getIslandCount();
    }
}

