/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.hm.achievement.api.AdvancedAchievementsAPI;
import com.hm.achievement.api.AdvancedAchievementsAPIFetcher;
import java.util.UUID;

@PluginInfo(name="AdvancedAchievements", iconName="star", iconFamily=Family.SOLID, color=Color.GREEN)
public class AdvancedAchievementsExtension
implements DataExtension {
    private final AdvancedAchievementsAPI api;

    AdvancedAchievementsExtension(AdvancedAchievementsAPI api) {
        this.api = api;
    }

    public AdvancedAchievementsExtension() {
        this.api = (AdvancedAchievementsAPI)AdvancedAchievementsAPIFetcher.fetchInstance().orElseThrow(() -> new IllegalStateException("API not present"));
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE};
    }

    @NumberProvider(text="Achievements", description="How many achievements the player has", iconName="check-circle", iconFamily=Family.REGULAR, iconColor=Color.GREEN, showInPlayerTable=true)
    public long achievementCount(UUID playerUUID) {
        return this.api.getPlayerTotalAchievements(playerUUID);
    }
}

