/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ABListener;
import com.djrapitops.extension.AdvancedBanExtension;
import com.djrapitops.plan.extension.Caller;
import java.util.UUID;
import me.leoko.advancedban.bungee.event.PunishmentEvent;
import me.leoko.advancedban.bungee.event.RevokePunishmentEvent;
import me.leoko.advancedban.utils.Punishment;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.event.EventHandler;

public class AdvancedBanBungeeABListener
implements ABListener,
Listener {
    private final Caller caller;

    public AdvancedBanBungeeABListener(Caller caller) {
        this.caller = caller;
    }

    @Override
    public void register() {
        PluginManager pluginManager = ProxyServer.getInstance().getPluginManager();
        Plugin plugin = pluginManager.getPlugin("Plan");
        pluginManager.registerListener(plugin, (Listener)this);
    }

    @EventHandler
    public void onPunish(PunishmentEvent event) {
        Punishment punishment = event.getPunishment();
        UUID playerUUID = AdvancedBanExtension.fromAbUUID(punishment.getUuid());
        if (playerUUID == null) {
            return;
        }
        this.caller.updatePlayerData(playerUUID, punishment.getName());
    }

    @EventHandler
    public void onRevoke(RevokePunishmentEvent event) {
        Punishment punishment = event.getPunishment();
        UUID playerUUID = AdvancedBanExtension.fromAbUUID(punishment.getUuid());
        if (playerUUID == null) {
            return;
        }
        this.caller.updatePlayerData(playerUUID, punishment.getName());
    }
}

