/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;
import me.leoko.advancedban.manager.PunishmentManager;
import me.leoko.advancedban.utils.PunishmentType;

@PluginInfo(name="AdvancedBan", iconName="gavel", iconFamily=Family.SOLID, color=Color.RED)
public class AdvancedBanExtension
implements DataExtension {
    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE};
    }

    private String abUUID(UUID uuid) {
        return uuid.toString().replace("-", "");
    }

    public static UUID fromAbUUID(String abUUID) {
        if (abUUID == null || abUUID.isEmpty() || abUUID.length() < 32) {
            return null;
        }
        return UUID.fromString(abUUID.substring(0, 8) + '-' + abUUID.substring(8, 12) + '-' + abUUID.substring(12, 16) + '-' + abUUID.substring(16, 20) + '-' + abUUID.substring(20));
    }

    private PunishmentManager getPunishmentManager() {
        try {
            return PunishmentManager.get();
        }
        catch (Exception e) {
            throw new NotReadyException();
        }
    }

    @BooleanProvider(text="Banned", description="Is the player banned on AdvancedBan", priority=100, conditionName="banned", iconName="gavel", iconColor=Color.RED)
    public boolean isBanned(UUID playerUUID) {
        return this.getPunishmentManager().isBanned(this.abUUID(playerUUID));
    }

    @Conditional(value="banned")
    @StringProvider(text="Operator", description="Who banned the player", priority=99, iconName="user", iconColor=Color.RED, playerName=true)
    public String banIssuer(UUID playerUUID) {
        return this.getPunishmentManager().getBan(this.abUUID(playerUUID)).getOperator();
    }

    @Conditional(value="banned")
    @NumberProvider(text="Date", description="When the ban was issued", priority=98, iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.RED, format=FormatType.DATE_YEAR)
    public long banIssueDate(UUID playerUUID) {
        return this.getPunishmentManager().getBan(this.abUUID(playerUUID)).getStart();
    }

    @Conditional(value="banned")
    @BooleanProvider(text="Will Expire", description="Is the ban permanent", priority=97, conditionName="ban_expires", iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.RED)
    public boolean banWillExpire(UUID playerUUID) {
        PunishmentType type = this.getPunishmentManager().getBan(this.abUUID(playerUUID)).getType();
        return type != PunishmentType.BAN && type != PunishmentType.IP_BAN && type != PunishmentType.MUTE;
    }

    @Conditional(value="ban_expires")
    @NumberProvider(text="Ends", description="When the ban expires", priority=96, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.RED, format=FormatType.DATE_YEAR)
    public long banExpireDate(UUID playerUUID) {
        return this.getPunishmentManager().getBan(this.abUUID(playerUUID)).getEnd();
    }

    @Conditional(value="banned")
    @StringProvider(text="Reason", description="Why the ban was issued", priority=95, iconName="comment", iconFamily=Family.REGULAR, iconColor=Color.RED)
    public String banReason(UUID playerUUID) {
        return this.getPunishmentManager().getBan(this.abUUID(playerUUID)).getReason();
    }

    @BooleanProvider(text="Muted", description="Is the player muted on AdvancedBan", priority=50, conditionName="muted", iconName="bell-slash", iconColor=Color.DEEP_ORANGE, showInPlayerTable=true)
    public boolean isMuted(UUID playerUUID) {
        return this.getPunishmentManager().isMuted(this.abUUID(playerUUID));
    }

    @Conditional(value="muted")
    @StringProvider(text="Operator", description="Who muted the player", priority=49, iconName="user", iconColor=Color.DEEP_ORANGE)
    public String muteIssuer(UUID playerUUID) {
        return this.getPunishmentManager().getMute(this.abUUID(playerUUID)).getOperator();
    }

    @Conditional(value="muted")
    @NumberProvider(text="Date", description="When the mute was issued", priority=48, iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_YEAR)
    public long muteIssueDate(UUID playerUUID) {
        return this.getPunishmentManager().getMute(this.abUUID(playerUUID)).getStart();
    }

    @Conditional(value="muted")
    @BooleanProvider(text="Will Expire", description="Is the mute permanent", priority=47, conditionName="mute_expires", iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE)
    public boolean muteWillExpire(UUID playerUUID) {
        PunishmentType type = this.getPunishmentManager().getMute(this.abUUID(playerUUID)).getType();
        return type != PunishmentType.BAN && type != PunishmentType.IP_BAN && type != PunishmentType.MUTE;
    }

    @Conditional(value="mute_expires")
    @NumberProvider(text="Ends", description="When the mute expires", priority=46, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_YEAR)
    public long muteExpireDate(UUID playerUUID) {
        return this.getPunishmentManager().getMute(this.abUUID(playerUUID)).getEnd();
    }

    @Conditional(value="muted")
    @StringProvider(text="Reason", description="Why the mute was issued", priority=45, iconName="comment", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE)
    public String muteReason(UUID playerUUID) {
        return this.getPunishmentManager().getMute(this.abUUID(playerUUID)).getReason();
    }

    @NumberProvider(text="Warnings", description="How many unexpired warnings player has on AdvancedBan", priority=25, iconName="flag", iconColor=Color.AMBER, showInPlayerTable=true)
    public long warnings(UUID playerUUID) {
        return this.getPunishmentManager().getWarns(this.abUUID(playerUUID)).stream().filter(warning -> !warning.isExpired()).count();
    }
}

