/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ABBukkitListenerFactory;
import com.djrapitops.extension.ABBungeeListenerFactory;
import com.djrapitops.extension.AdvancedBanExtension;
import com.djrapitops.plan.capability.CapabilityService;
import com.djrapitops.plan.extension.Caller;
import com.djrapitops.plan.extension.DataExtension;
import java.util.Optional;

public class AdvancedBanExtensionFactory {
    private boolean isAvailable(String className) {
        try {
            Class.forName(className);
            return CapabilityService.getInstance().hasCapability("DATA_EXTENSION_SHOW_IN_PLAYER_TABLE");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isAvailable() {
        return this.isAvailable("me.leoko.advancedban.Universal");
    }

    public Optional<DataExtension> createExtension() {
        if (this.isAvailable()) {
            return Optional.of(new AdvancedBanExtension());
        }
        return Optional.empty();
    }

    public void registerListener(Caller caller) {
        if (this.isAvailable("org.bukkit.event.EventHandler")) {
            ABBukkitListenerFactory.createBukkitListener(caller).register();
        }
        if (this.isAvailable("net.md_5.bungee.event.EventHandler")) {
            ABBungeeListenerFactory.createBungeeListener(caller).register();
        }
    }
}

