/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;
import me.confuser.banmanager.BmAPI;
import me.confuser.banmanager.data.PlayerBanData;
import me.confuser.banmanager.data.PlayerMuteData;

@PluginInfo(name="BanManager", iconName="gavel", iconFamily=Family.SOLID, color=Color.BROWN)
public class BanManagerExtension
implements DataExtension {
    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE};
    }

    @BooleanProvider(text="Banned", description="Is the player banned on BanManager", priority=100, conditionName="banned", iconName="gavel", iconColor=Color.RED)
    public boolean isBanned(UUID playerUUID) {
        return BmAPI.isBanned((UUID)playerUUID);
    }

    @Conditional(value="banned")
    @StringProvider(text="Banned by", description="Who banned the player", priority=99, iconName="user", iconColor=Color.RED, playerName=true)
    public String banIssuer(UUID playerUUID) {
        return this.getCurrentBan(playerUUID).getActor().getName();
    }

    private PlayerBanData getCurrentBan(UUID playerUUID) {
        return BmAPI.getCurrentBan((UUID)playerUUID);
    }

    @Conditional(value="banned")
    @NumberProvider(text="Date", description="When the ban was issued", priority=98, iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.RED, format=FormatType.DATE_YEAR)
    public long banIssueDate(UUID playerUUID) {
        return this.getCurrentBan(playerUUID).getCreated();
    }

    @Conditional(value="banned")
    @NumberProvider(text="Ends", description="When the ban expires", priority=96, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.RED, format=FormatType.DATE_YEAR)
    public long banExpireDate(UUID playerUUID) {
        return this.getCurrentBan(playerUUID).getExpires();
    }

    @Conditional(value="banned")
    @StringProvider(text="Reason", description="Why the ban was issued", priority=95, iconName="comment", iconFamily=Family.REGULAR, iconColor=Color.RED)
    public String banReason(UUID playerUUID) {
        return this.getCurrentBan(playerUUID).getReason();
    }

    @BooleanProvider(text="Muted", description="Is the player muted on BanManager", priority=50, conditionName="muted", iconName="bell-slash", iconColor=Color.DEEP_ORANGE)
    public boolean isMuted(UUID playerUUID) {
        return BmAPI.isMuted((UUID)playerUUID);
    }

    @Conditional(value="muted")
    @StringProvider(text="Muted by", description="Who muted the player", priority=49, iconName="user", iconColor=Color.DEEP_ORANGE, playerName=true)
    public String muteIssuer(UUID playerUUID) {
        return this.getCurrentMute(playerUUID).getActor().getName();
    }

    private PlayerMuteData getCurrentMute(UUID playerUUID) {
        return BmAPI.getCurrentMute((UUID)playerUUID);
    }

    @Conditional(value="muted")
    @NumberProvider(text="Date", description="When the mute was issued", priority=48, iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_YEAR)
    public long muteIssueDate(UUID playerUUID) {
        return this.getCurrentMute(playerUUID).getCreated();
    }

    @Conditional(value="muted")
    @NumberProvider(text="Ends", description="When the mute expires", priority=46, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_YEAR)
    public long muteExpireDate(UUID playerUUID) {
        return this.getCurrentMute(playerUUID).getExpires();
    }

    @Conditional(value="muted")
    @StringProvider(text="Reason", description="Why the mute was issued", priority=45, iconName="comment", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE)
    public String muteReason(UUID playerUUID) {
        return this.getCurrentMute(playerUUID).getReason();
    }
}

