/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TabOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.addons.request.AddonRequestBuilder;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.AddonsManager;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.managers.PlayersManager;

@TabInfo(tab="Islands", iconName="street-view", elementOrder={ElementOrder.VALUES})
@TabOrder(value={"Islands"})
public abstract class BentoBoxExtension
implements DataExtension {
    private final String addOnName;
    private IslandsManager islands;
    private PlayersManager players;
    private AddonsManager addOns;

    protected BentoBoxExtension() {
        this.addOnName = null;
    }

    protected BentoBoxExtension(String addOnName) {
        this.addOnName = addOnName;
        this.prepare();
    }

    private void prepare() {
        if (!Bukkit.getPluginManager().isPluginEnabled("BentoBox")) {
            throw new NotReadyException();
        }
        BentoBox plugin = (BentoBox)JavaPlugin.getPlugin(BentoBox.class);
        this.islands = plugin.getIslands();
        this.players = plugin.getPlayers();
        this.addOns = plugin.getAddonsManager();
        this.addOns.getAddonByName(this.addOnName).orElseThrow(NotReadyException::new);
    }

    private World getWorld() {
        return this.addOns.getAddonByName(this.addOnName).filter(addOn -> addOn instanceof GameModeAddon).map(addOn -> (GameModeAddon)addOn).map(GameModeAddon::getOverWorld).orElseThrow(NotReadyException::new);
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @BooleanProvider(text="Has Island", description="Does the player have an island", priority=100, conditionName="hasIsland", iconName="street-view", iconColor=Color.GREEN)
    @Tab(value="Islands")
    public boolean hasIsland(UUID playerUUID) {
        return this.islands.hasIsland(this.getWorld(), playerUUID);
    }

    @Conditional(value="hasIsland")
    @StringProvider(text="Island name", description="Name of the player's island", iconName="street-view", iconColor=Color.GREEN, priority=99, showInPlayerTable=true)
    @Tab(value="Islands")
    public String islandName(UUID playerUUID) {
        String name = this.getIsland(playerUUID).getName();
        return name != null ? name : "-";
    }

    private Island getIsland(UUID playerUUID) {
        Island island = this.islands.getIsland(this.getWorld(), playerUUID);
        if (island == null) {
            throw new NotReadyException();
        }
        return island;
    }

    @Conditional(value="hasIsland")
    @NumberProvider(text="Island level", description="Level of the player's island", iconName="street-view", iconColor=Color.AMBER, priority=98)
    @Tab(value="Islands")
    public long islandLevel(UUID playerUUID) {
        World world = this.getWorld();
        Object level = new AddonRequestBuilder().addon("Levels").label("island-level").addMetaData("world-name", (Object)world.getName()).addMetaData("player", (Object)playerUUID).request();
        if (level instanceof Long) {
            return (Long)level;
        }
        throw new NotReadyException();
    }

    @Conditional(value="hasIsland")
    @NumberProvider(text="Island Created", description="When the Island was created", iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.GREEN, priority=97, format=FormatType.DATE_YEAR)
    @Tab(value="Islands")
    public long islandCreated(UUID playerUUID) {
        return this.getIsland(playerUUID).getCreatedDate();
    }

    @Conditional(value="hasIsland")
    @NumberProvider(text="Last Changed", description="When the Island was changed last time", iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.GREEN, priority=98, format=FormatType.DATE_SECOND)
    @Tab(value="Islands")
    public long islandUpdated(UUID playerUUID) {
        return this.getIsland(playerUUID).getUpdatedDate();
    }

    @Conditional(value="hasIsland")
    @NumberProvider(text="Island Resets Left", description="How many times can the player reset their island", iconName="street-view", iconColor=Color.GREEN, priority=99)
    @Tab(value="Islands")
    public long islandResets(UUID playerUUID) {
        return this.players.getResetsLeft(this.getWorld(), playerUUID);
    }

    @StringProvider(text="Island World", description="What world is used for ASkyBlock islands", priority=102, iconName="map", iconColor=Color.GREEN, iconFamily=Family.REGULAR)
    @Tab(value="Islands")
    public String islandWorld() {
        return this.getWorld().getName();
    }
}

