/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.NuVotifierStorage;
import com.vexsoftware.votifier.bungee.events.VotifierEvent;
import com.vexsoftware.votifier.model.Vote;
import java.util.concurrent.ExecutionException;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class BungeeVoteListener
implements Listener {
    private final NuVotifierStorage storage;
    private final Plugin plugin;

    BungeeVoteListener(NuVotifierStorage storage) {
        this.storage = storage;
        this.plugin = ProxyServer.getInstance().getPluginManager().getPlugin("Plan");
    }

    public void register() {
        ProxyServer.getInstance().getPluginManager().registerListener(this.plugin, (Listener)this);
    }

    @EventHandler(priority=64)
    public void onVote(VotifierEvent event) {
        Vote vote = event.getVote();
        String service = vote.getServiceName();
        String username = vote.getUsername();
        ProxyServer.getInstance().getScheduler().runAsync(this.plugin, () -> {
            try {
                this.storage.storeVote(username, service);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        });
    }
}

