/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ListPaymentRequest;
import com.djrapitops.extension.Payment;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;

@PluginInfo(name="Buycraft", iconName="shopping-bag", iconFamily=Family.SOLID, color=Color.BLUE)
public class BuycraftExtension
implements DataExtension {
    private final String secret;
    private SimpleDateFormat formatter;
    private DecimalFormat decimalFormatter;

    public BuycraftExtension(String secret) {
        this.secret = secret;
        this.formatter = new SimpleDateFormat("MMM d YYYY, HH:mm");
        this.decimalFormatter = new DecimalFormat("#0.00");
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.SERVER_PERIODICAL};
    }

    @TableProvider(tableColor=Color.BLUE)
    public Table purchaseTable() {
        Table.Factory table = Table.builder().columnOne("Player", Icon.called("user").build()).columnTwo("Date", Icon.called("calendar").of(Family.REGULAR).build()).columnThree("Amount", Icon.called("money-bill-wave").build()).columnFour("Packages", Icon.called("cube").build());
        List<Payment> payments = new ListPaymentRequest(this.secret).makeRequest();
        Collections.sort(payments);
        for (Payment payment : payments) {
            String name = payment.getPlayerName();
            table.addRow(name, this.formatter.format(payment.getDate()), this.decimalFormatter.format(payment.getAmount()) + " " + payment.getCurrency(), payment.getPackages());
        }
        return table.build();
    }
}

