/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.InvalidateMethod;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@PluginInfo(name="CoreProtect", iconName="user-shield", iconFamily=Family.SOLID, color=Color.LIGHT_BLUE)
@InvalidateMethod.Multiple(value={@InvalidateMethod(value="blocksPlaced30"), @InvalidateMethod(value="blocksBroken30"), @InvalidateMethod(value="blocksInteractedWith30")})
public class CoreProtectExtension
implements DataExtension {
    private static final int ACTION_REMOVED = 0;
    private static final int ACTION_PLACED = 1;
    private static final int ACTION_INTERACT = 2;
    private CoreProtectAPI api;

    CoreProtectExtension(boolean b) {
    }

    public CoreProtectExtension() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("CoreProtect");
        if (!(plugin instanceof CoreProtect)) {
            throw new IllegalStateException();
        }
        this.api = ((CoreProtect)plugin).getAPI();
        if (!this.api.isEnabled()) {
            throw new IllegalStateException();
        }
        if (this.api.APIVersion() < 5) {
            throw new IllegalStateException();
        }
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE};
    }

    private long lookupInteractionCount(String playerName, int action) {
        if (!this.api.isEnabled()) {
            throw new NotReadyException();
        }
        return this.api.performLookup((int)TimeUnit.DAYS.toSeconds(7L), Collections.singletonList(playerName), null, null, null, Collections.singletonList(action), 0, null).stream().map(arg_0 -> ((CoreProtectAPI)this.api).parseResult(arg_0)).filter(result -> !result.isRolledBack()).count();
    }

    @NumberProvider(text="Blocks Placed (7 Days)", description="How many block place actions the player has that have not been rolled back (From last seen).", priority=10, iconName="cube", iconColor=Color.LIGHT_BLUE, showInPlayerTable=true)
    public long blocksPlaced7(String playerName) {
        return this.lookupInteractionCount(playerName, 0);
    }

    @NumberProvider(text="Blocks Broken (7 Days)", description="How many block break actions the player has that have not been rolled back (From last seen).", priority=9, iconName="cube", iconColor=Color.BROWN, showInPlayerTable=true)
    public long blocksBroken7(String playerName) {
        return this.lookupInteractionCount(playerName, 1);
    }

    @NumberProvider(text="Block Interactions (7 Days)", description="How many block interact actions the player has that have not been rolled back (From last seen).", priority=8, iconName="fingerprint", iconColor=Color.LIGHT_BLUE)
    public long blocksInteractedWith7(String playerName) {
        return this.lookupInteractionCount(playerName, 2);
    }
}

