/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import ch.dkrieger.bansystem.lib.BanSystem;
import ch.dkrieger.bansystem.lib.player.history.BanType;
import ch.dkrieger.bansystem.lib.stats.NetworkStats;
import ch.dkrieger.bansystem.lib.stats.PlayerStats;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PercentageProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;
import java.util.regex.Pattern;

@PluginInfo(name="DKBans", iconName="gavel", iconFamily=Family.SOLID, color=Color.RED)
public class DKBansExtension
implements DataExtension {
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_EXTENSION_REGISTER, CallEvents.SERVER_PERIODICAL};
    }

    private double calculatePercentage(double input1, double input2) {
        if (input1 == 0.0 || input2 == 0.0) {
            return 0.0;
        }
        return input1 / input2;
    }

    private String strip(String input) {
        return STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    private BanSystem getBanSystem() {
        return BanSystem.getInstance();
    }

    @BooleanProvider(text="Banned", description="Is the player banned on DKBans", priority=100, conditionName="banned", iconName="gavel", iconColor=Color.RED)
    public boolean isBanned(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).isBanned(BanType.NETWORK);
    }

    @Conditional(value="banned")
    @StringProvider(text="Operator", description="Who banned the player", priority=99, iconName="user", iconColor=Color.RED, playerName=true)
    public String banIssuer(UUID playerUUID) {
        return this.strip(this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.NETWORK).getStaffName());
    }

    @Conditional(value="banned")
    @NumberProvider(text="Date", description="When the ban was issued", priority=98, iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.RED, format=FormatType.DATE_YEAR)
    public long banIssueDate(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.NETWORK).getTimeStamp();
    }

    @Conditional(value="banned")
    @BooleanProvider(text="Will Expire", description="Is the ban permanent", priority=97, conditionName="ban_expires", iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.RED)
    public boolean banWillExpire(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.NETWORK).getTimeOut() > 0L;
    }

    @Conditional(value="ban_expires")
    @NumberProvider(text="Ends", description="When the ban expires", priority=96, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.RED, format=FormatType.DATE_YEAR)
    public long banExpireDate(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.NETWORK).getTimeOut();
    }

    @Conditional(value="banned")
    @StringProvider(text="Reason", description="Why the ban was issued", priority=95, iconName="comment", iconFamily=Family.REGULAR, iconColor=Color.RED)
    public String banReason(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.NETWORK).getReason();
    }

    @BooleanProvider(text="Muted", description="Is the player muted on DKBans", priority=50, conditionName="muted", iconName="bell-slash", iconColor=Color.DEEP_ORANGE, showInPlayerTable=true)
    public boolean isMuted(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).isBanned(BanType.CHAT);
    }

    @Conditional(value="muted")
    @StringProvider(text="Operator", description="Who muted the player", priority=49, iconName="user", iconColor=Color.DEEP_ORANGE, playerName=true)
    public String muteIssuer(UUID playerUUID) {
        return this.strip(this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.CHAT).getStaffName());
    }

    @Conditional(value="muted")
    @NumberProvider(text="Date", description="When the mute was issued", priority=48, iconName="calendar", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_YEAR)
    public long muteIssueDate(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.CHAT).getTimeStamp();
    }

    @Conditional(value="muted")
    @BooleanProvider(text="Will Expire", description="Is the mute permanent", priority=47, conditionName="mute_expires", iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE)
    public boolean muteWillExpire(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.CHAT).getTimeOut() > 0L;
    }

    @Conditional(value="mute_expires")
    @NumberProvider(text="Ends", description="When the mute expires", priority=46, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_YEAR)
    public long muteExpireDate(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.CHAT).getTimeOut();
    }

    @Conditional(value="muted")
    @StringProvider(text="Reason", description="Why the mute was issued", priority=45, iconName="comment", iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE)
    public String muteReason(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getBan(BanType.CHAT).getReason();
    }

    @NumberProvider(text="Bans", description="How many bans the player has on DKBans", priority=25, iconName="flag", iconColor=Color.AMBER, showInPlayerTable=true)
    public long bans(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getStats().getBans();
    }

    @NumberProvider(text="Unbans", description="How many unbans the player has on DKBans", priority=24, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.AMBER, showInPlayerTable=true)
    public long unbans(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getStats().getUnbans();
    }

    @NumberProvider(text="Mutes", description="How many mutes the player has on DKBans", priority=23, iconName="volume-mute", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public long mutes(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getStats().getMutes();
    }

    @NumberProvider(text="Warnings", description="How many warnings the player has on DKBans", priority=22, iconName="exclamation", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public long warnings(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getStats().getWarns();
    }

    @NumberProvider(text="Reports", description="How many reports the player has on DKBans", priority=21, iconName="exclamation", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public long reports(UUID playerUUID) {
        return this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getStats().getReports();
    }

    @PercentageProvider(text="Report accept ratio", description="The accepted/denied ratio for reports on DKBans", priority=20, iconName="exclamation", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public double reportPercentage(UUID playerUUID) {
        PlayerStats stats = this.getBanSystem().getPlayerManager().getPlayer(playerUUID).getStats();
        long accepted = stats.getReportsAccepted();
        return this.calculatePercentage(stats.getReportsDenied() + accepted, accepted);
    }

    @NumberProvider(text="Bans", description="Total amount of bans on DKBans", priority=25, iconName="flag", iconColor=Color.AMBER)
    public long bans() {
        return this.getBanSystem().getNetworkStats().getBans();
    }

    @NumberProvider(text="Unbans", description="Total amount of unbans on DKBans", priority=24, iconName="calendar-check", iconFamily=Family.REGULAR, iconColor=Color.AMBER, showInPlayerTable=true)
    public long unbans() {
        return this.getBanSystem().getNetworkStats().getUnbans();
    }

    @NumberProvider(text="Mutes", description="Total amount of mutes on DKBans", priority=23, iconName="volume-mute", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public long mutes() {
        return this.getBanSystem().getNetworkStats().getMutes();
    }

    @NumberProvider(text="Warnings", description="Total amount of warnings on DKBans", priority=22, iconName="exclamation", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public long warnings() {
        return this.getBanSystem().getNetworkStats().getWarns();
    }

    @NumberProvider(text="Reports", description="Total amount of reports on DKBans", priority=21, iconName="exclamation", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public long reports() {
        return this.getBanSystem().getNetworkStats().getReports();
    }

    @PercentageProvider(text="Report accept ratio", description="The global accepted/denied ratio for reports on DKBans", priority=20, iconName="exclamation", iconFamily=Family.SOLID, iconColor=Color.AMBER, showInPlayerTable=true)
    public double reportPercentage() {
        NetworkStats stats = this.getBanSystem().getNetworkStats();
        long accepted = stats.getReportsAccepted();
        return this.calculatePercentage(stats.getReportsDenied() + accepted, accepted);
    }
}

