/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import ch.dkrieger.coinsystem.core.CoinSystem;
import ch.dkrieger.coinsystem.core.player.CoinPlayer;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;

@PluginInfo(name="DKCoins", iconName="coins", iconFamily=Family.SOLID, color=Color.YELLOW)
public class DKCoinsExtension
implements DataExtension {
    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN};
    }

    private CoinSystem getCoinSystem() {
        return CoinSystem.getInstance();
    }

    private CoinPlayer getCoinPlayer(UUID playerUUID) {
        CoinPlayer player = this.getCoinSystem().getPlayerManager().getPlayer(playerUUID);
        if (player == null) {
            throw new NotReadyException();
        }
        return player;
    }

    @NumberProvider(text="Coins", description="The amount of coins the player has on DKCoins", priority=100, iconName="coins", iconColor=Color.GREEN)
    public long coins(UUID playerUUID) {
        return this.getCoinPlayer(playerUUID).getCoins();
    }

    @StringProvider(text="Name", description="The name for the player on DKCoins", priority=99, iconName="signature", iconColor=Color.GREEN)
    public String name(UUID playerUUID) {
        return this.getCoinPlayer(playerUUID).getName();
    }
}

