/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.Caller;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.AccountLinkedEvent;
import github.scarsz.discordsrv.api.events.AccountUnlinkedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberJoinEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberLeaveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberRoleAddEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberRoleRemoveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.update.GuildMemberUpdateNicknameEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.user.update.UserUpdateDiscriminatorEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.user.update.UserUpdateNameEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class DiscordSRVListener
extends ListenerAdapter {
    private final Caller caller;

    public DiscordSRVListener(Caller caller) {
        this.caller = caller;
    }

    private void updateUser(User user) {
        if (user == null) {
            return;
        }
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(user.getId());
        if (uuid == null) {
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        this.caller.updatePlayerData(uuid, offlinePlayer.getName());
    }

    @Subscribe
    public void onAccountUnlink(AccountUnlinkedEvent event) {
        OfflinePlayer player = event.getPlayer();
        this.caller.updatePlayerData(player.getUniqueId(), player.getName());
    }

    @Subscribe
    public void onAccountLink(AccountLinkedEvent event) {
        OfflinePlayer player = event.getPlayer();
        this.caller.updatePlayerData(player.getUniqueId(), player.getName());
    }

    public void onGuildMemberRoleAdd(@Nonnull GuildMemberRoleAddEvent event) {
        this.updateUser(event.getUser());
    }

    public void onGuildMemberRoleRemove(@Nonnull GuildMemberRoleRemoveEvent event) {
        this.updateUser(event.getUser());
    }

    public void onGuildMemberUpdateNickname(@Nonnull GuildMemberUpdateNicknameEvent event) {
        this.updateUser(event.getUser());
    }

    public void onUserUpdateName(@Nonnull UserUpdateNameEvent event) {
        this.updateUser(event.getUser());
    }

    public void onGuildMemberJoin(@Nonnull GuildMemberJoinEvent event) {
        this.updateUser(event.getUser());
    }

    public void onGuildMemberLeave(@Nonnull GuildMemberLeaveEvent event) {
        this.updateUser(event.getUser());
    }

    public void onUserUpdateDiscriminator(@Nonnull UserUpdateDiscriminatorEvent event) {
        this.updateUser(event.getUser());
    }
}

