/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.DoubleProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

@PluginInfo(name="Economy (Vault)", iconName="money-bill-wave", iconFamily=Family.SOLID, color=Color.GREEN)
public class EconomyExtension
implements DataExtension {
    private Economy eco;

    public EconomyExtension() {
        RegisteredServiceProvider registration = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            throw new NotReadyException();
        }
        this.eco = (Economy)registration.getProvider();
    }

    @DoubleProvider(text="Balance", description="How much money the player has", iconName="money-bill-wave", iconColor=Color.GREEN, showInPlayerTable=true)
    public double balance(UUID playerUUID) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        return this.eco.hasAccount(player) ? this.eco.getBalance(player) : 0.0;
    }
}

