/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.Caller;
import java.util.UUID;
import net.ess3.api.IUser;
import net.ess3.api.events.JailStatusChangeEvent;
import net.ess3.api.events.MuteStatusChangeEvent;
import net.ess3.api.events.UserBalanceUpdateEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EssentialsEventListener
implements Listener {
    private final Caller caller;

    public EssentialsEventListener(Caller caller) {
        this.caller = caller;
    }

    public static void register(Caller caller) {
        Plugin plan = Bukkit.getPluginManager().getPlugin("Plan");
        Bukkit.getPluginManager().registerEvents((Listener)new EssentialsEventListener(caller), plan);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJailStatusChange(JailStatusChangeEvent event) {
        IUser affected = event.getAffected();
        UUID playerUUID = affected.getBase().getUniqueId();
        String playerName = affected.getName();
        this.caller.updatePlayerData(playerUUID, playerName);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMuteStatusChange(MuteStatusChangeEvent event) {
        IUser affected = event.getAffected();
        UUID playerUUID = affected.getBase().getUniqueId();
        String playerName = affected.getName();
        this.caller.updatePlayerData(playerUUID, playerName);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBalanceChange(UserBalanceUpdateEvent event) {
        Player player = event.getPlayer();
        this.caller.updatePlayerData(player.getUniqueId(), player.getName());
    }
}

