/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.DoubleProvider;
import com.djrapitops.plan.extension.annotation.InvalidateMethod;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.java.JavaPlugin;

@PluginInfo(name="Essentials", iconName="flask", iconFamily=Family.SOLID, color=Color.DEEP_ORANGE)
@InvalidateMethod(value="hasUser")
public class EssentialsExtension
implements DataExtension {
    private Essentials essentials;

    EssentialsExtension(boolean b) {
    }

    EssentialsExtension() {
        this.essentials = (Essentials)JavaPlugin.getPlugin(Essentials.class);
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_EXTENSION_REGISTER, CallEvents.SERVER_PERIODICAL};
    }

    private User getUser(UUID playerUUID) {
        User user = this.essentials.getUser(playerUUID);
        if (user == null) {
            throw new NotReadyException();
        }
        return user;
    }

    @BooleanProvider(text="Jailed", iconName="ban", priority=100, iconColor=Color.DEEP_ORANGE, conditionName="isJailed")
    public boolean isJailed(UUID playerUUID) {
        return this.getUser(playerUUID).isJailed();
    }

    @Conditional(value="isJailed")
    @NumberProvider(text="Jail Expires", iconName="calendar-times", priority=99, iconFamily=Family.REGULAR, iconColor=Color.DEEP_ORANGE, format=FormatType.DATE_SECOND)
    public long jailTimeout(UUID playerUUID) {
        return this.getUser(playerUUID).getJailTimeout();
    }

    @BooleanProvider(text="Muted", iconName="bell-slash", priority=80, iconColor=Color.BLUE_GREY, conditionName="isMuted")
    public boolean isMuted(UUID playerUUID) {
        return this.getUser(playerUUID).isMuted();
    }

    @Conditional(value="isMuted")
    @NumberProvider(text="Mute Expires", iconName="calendar-times", priority=79, iconFamily=Family.REGULAR, iconColor=Color.BLUE_GREY, format=FormatType.DATE_SECOND)
    public long muteTimeout(UUID playerUUID) {
        return this.getUser(playerUUID).getJailTimeout();
    }

    @StringProvider(text="homes", iconName="home", priority=70, iconColor=Color.GREEN)
    public String playerHomes(UUID playerUUID) {
        List homes = this.getUser(playerUUID).getHomes();
        if (homes.isEmpty()) {
            return "-";
        }
        Collections.sort(homes);
        StringBuilder homeString = new StringBuilder();
        int size = homes.size();
        for (int i = 0; i < size; ++i) {
            homeString.append((String)homes.get(i));
            if (i >= size - 1) continue;
            homeString.append(", ");
        }
        return homeString.toString();
    }

    @DoubleProvider(text="Balance", iconName="coins", priority=60, iconColor=Color.GREEN)
    public double balance(UUID playerUUID) {
        if (this.essentials.getSettings().isEcoDisabled()) {
            throw new NotReadyException();
        }
        return this.getUser(playerUUID).getMoney().doubleValue();
    }

    @DoubleProvider(text="Total Server Balance", iconName="coins", priority=50, iconColor=Color.GREEN)
    public double totalServerBalance() {
        if (this.essentials.getSettings().isEcoDisabled()) {
            throw new NotReadyException();
        }
        BigDecimal totalMoney = BigDecimal.ZERO;
        for (UUID uuid : this.essentials.getUserMap().getAllUniqueUsers()) {
            User user = this.essentials.getUserMap().getUser(uuid);
            if (user == null || !this.essentials.getSettings().isNpcsInBalanceRanking() && user.isNPC() || user.isAuthorized("essentials.balancetop.exclude")) continue;
            BigDecimal userMoney = user.getMoney();
            user.updateMoneyCache(userMoney);
            totalMoney = totalMoney.add(userMoney);
        }
        return totalMoney.doubleValue();
    }
}

