/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.util.List;
import java.util.UUID;
import me.ryanhamshire.griefprevention.GriefPrevention;
import me.ryanhamshire.griefprevention.api.GriefPreventionApi;
import me.ryanhamshire.griefprevention.api.claim.Claim;
import org.spongepowered.api.world.Location;

@PluginInfo(name="GriefPrevention", iconName="shield-alt", iconFamily=Family.SOLID, color=Color.BLUE_GREY)
@TabInfo(tab="Claims", iconName="map-marker", elementOrder={ElementOrder.TABLE})
public class GriefPreventionSpongeExtension
implements DataExtension {
    private GriefPreventionApi api = GriefPrevention.getApi();

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE};
    }

    @NumberProvider(text="Claims", description="How many claims the player has", iconName="map-marker", iconColor=Color.BLUE_GREY)
    public long claimCount(UUID playerUUID) {
        return this.getClaimsOf(playerUUID).size();
    }

    @NumberProvider(text="Claimed Area", description="How large area the player has claimed", iconName="map", iconColor=Color.BLUE_GREY, iconFamily=Family.REGULAR, showInPlayerTable=true)
    public long claimedArea(UUID playerUUID) {
        return this.getClaimsOf(playerUUID).stream().mapToLong(Claim::getArea).sum();
    }

    private List<Claim> getClaimsOf(UUID playerUUID) {
        return this.api.getAllPlayerClaims(playerUUID);
    }

    @TableProvider(tableColor=Color.BLUE_GREY)
    @Tab(value="Claims")
    public Table claimTable(UUID playerUUID) {
        Table.Factory table = Table.builder().columnOne("Claim", Icon.called("map-marker").build()).columnTwo("Area", Icon.called("map").of(Family.REGULAR).build());
        this.getClaimsOf(playerUUID).stream().sorted((one, two) -> Integer.compare(two.getArea(), one.getArea())).forEach(claim -> table.addRow(this.formatLocation(claim.getGreaterBoundaryCorner()), claim.getArea()));
        return table.build();
    }

    private String formatLocation(Location greaterBoundaryCorner) {
        return "x: " + greaterBoundaryCorner.getBlockX() + " z: " + greaterBoundaryCorner.getBlockZ();
    }
}

