/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.GroupProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.dao.JobsDAO;
import com.gamingmesh.jobs.dao.JobsDAOData;
import java.util.List;
import java.util.UUID;

@PluginInfo(name="Jobs", iconName="suitcase", iconFamily=Family.SOLID, color=Color.BROWN)
public class JobsExtension
implements DataExtension {
    private JobsDAO getDB() {
        return Jobs.getDBManager().getDB();
    }

    @GroupProvider(text="Job", iconName="suitcase", groupColor=Color.BROWN)
    public String[] jobs(UUID playerUUID) {
        List jobs = this.getDB().getAllJobs(null, playerUUID);
        if (jobs.isEmpty()) {
            return new String[]{"No Job"};
        }
        return (String[])jobs.stream().map(JobsDAOData::getJobName).toArray(String[]::new);
    }

    @TableProvider(tableColor=Color.BROWN)
    public Table jobLevelTable(UUID playerUUID) {
        Table.Factory table = Table.builder().columnOne("Job", Icon.called("suitcase").build()).columnTwo("Level", Icon.called("plus").build());
        List jobs = this.getDB().getAllJobs(null, playerUUID);
        for (JobsDAOData job : jobs) {
            table.addRow(job.getJobName(), job.getLevel());
        }
        return table.build();
    }
}

