/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.Payment;
import com.djrapitops.plan.extension.NotReadyException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import plan.com.google.gson.JsonArray;
import plan.com.google.gson.JsonElement;
import plan.com.google.gson.JsonObject;
import plan.com.google.gson.JsonParser;

public class ListPaymentRequest {
    private final String secret;

    public ListPaymentRequest(String secret) {
        this.secret = secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Payment> makeRequest() {
        try {
            JsonElement json;
            URL url = new URL("https://plugin.tebex.io/payments");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("X-Tebex-Secret", this.secret);
            try {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                json = new JsonParser().parse(reader);
            }
            finally {
                connection.disconnect();
            }
            if (json == null || json.isJsonNull()) {
                throw new NullPointerException("JSON should not be null");
            }
            ArrayList<Payment> payments = new ArrayList<Payment>();
            if (json.isJsonObject()) {
                throw new NotReadyException();
            }
            if (json.isJsonArray()) {
                this.readAndAddPayments(json, payments);
            }
            return payments;
        }
        catch (IOException e) {
            throw new NotReadyException();
        }
    }

    private void readAndAddPayments(JsonElement json, List<Payment> payments) {
        JsonArray jsonArray = json.getAsJsonArray();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        for (JsonElement element : jsonArray) {
            JsonObject payment = element.getAsJsonObject();
            double amount = payment.get("amount").getAsDouble();
            String dateString = payment.get("date").getAsString();
            Date dateObj = dateFormat.parse(dateString, new ParsePosition(0));
            long date = dateObj.getTime();
            String currency = payment.get("currency").getAsJsonObject().get("iso_4217").getAsString();
            JsonObject player = payment.get("player").getAsJsonObject();
            String playerName = player.get("name").getAsString();
            StringBuilder packages = new StringBuilder();
            for (JsonElement pack : payment.get("packages").getAsJsonArray()) {
                packages.append(pack.getAsJsonObject().get("name")).append("<br>");
            }
            payments.add(new Payment(amount, currency, null, playerName, date, packages.toString()));
        }
    }
}

