/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.LitebansDBEntry;
import com.djrapitops.extension.LitebansDatabaseQueries;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.Caller;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.query.QueryService;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.UUID;
import litebans.api.Entry;
import litebans.api.Events;

@PluginInfo(name="Litebans", iconName="gavel", iconFamily=Family.SOLID, color=Color.RED)
@TabInfo.Multiple(value={@TabInfo(tab="Bans", iconName="gavel", elementOrder={}), @TabInfo(tab="Mutes", iconName="bell-slash", iconFamily=Family.REGULAR, elementOrder={}), @TabInfo(tab="Warnings", iconName="exclamation-triangle", elementOrder={}), @TabInfo(tab="Kicks", iconName="user-times", elementOrder={})})
public class LitebansExtension
implements DataExtension {
    private LitebansDatabaseQueries queries = new LitebansDatabaseQueries();
    private SimpleDateFormat formatter = new SimpleDateFormat("MMM d YYYY, HH:mm");

    public static void registerEvents(final Caller caller) {
        Events.get().register(new Events.Listener(){

            public void entryAdded(Entry entry) {
                this.update(entry);
            }

            private void update(Entry entry) {
                String uuid = entry.getUuid();
                if (uuid == null) {
                    return;
                }
                try {
                    caller.updatePlayerData(UUID.fromString(uuid), null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public void entryRemoved(Entry entry) {
                this.update(entry);
            }
        });
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @TableProvider(tableColor=Color.RED)
    @Tab(value="Bans")
    public Table bans(UUID playerUUID) {
        Table.Factory table = this.playerTable();
        this.addRows(table, this.queries.getBans(playerUUID));
        return table.build();
    }

    @TableProvider(tableColor=Color.DEEP_ORANGE)
    @Tab(value="Mutes")
    public Table mutes(UUID playerUUID) {
        Table.Factory table = this.playerTable();
        this.addRows(table, this.queries.getMutes(playerUUID));
        return table.build();
    }

    @TableProvider(tableColor=Color.AMBER)
    @Tab(value="Warnings")
    public Table warns(UUID playerUUID) {
        Table.Factory table = this.playerTable();
        this.addRows(table, this.queries.getWarnings(playerUUID));
        return table.build();
    }

    @TableProvider(tableColor=Color.BROWN)
    @Tab(value="Kicks")
    public Table kicks(UUID playerUUID) {
        Table.Factory table = this.playerTable();
        this.addRows(table, this.queries.getKicks(playerUUID));
        return table.build();
    }

    @TableProvider(tableColor=Color.RED)
    @Tab(value="Bans")
    public Table serverBans() {
        Table.Factory table = this.serverTable();
        this.addRows(table, QueryService.getInstance(), this.queries.getBans());
        return table.build();
    }

    @TableProvider(tableColor=Color.DEEP_ORANGE)
    @Tab(value="Mutes")
    public Table serverMutes() {
        Table.Factory table = this.serverTable();
        this.addRows(table, QueryService.getInstance(), this.queries.getMutes());
        return table.build();
    }

    @TableProvider(tableColor=Color.AMBER)
    @Tab(value="Warnings")
    public Table serverWarns() {
        Table.Factory table = this.serverTable();
        this.addRows(table, QueryService.getInstance(), this.queries.getWarnings());
        return table.build();
    }

    @TableProvider(tableColor=Color.BROWN)
    @Tab(value="Kicks")
    public Table serverKicks() {
        Table.Factory table = this.serverTable();
        this.addRows(table, QueryService.getInstance(), this.queries.getKicks());
        return table.build();
    }

    private Table.Factory playerTable() {
        return Table.builder().columnOne("Reason", Icon.called("balance-scale").build()).columnTwo("By", Icon.called("user-shield").build()).columnThree("Given", Icon.called("clock").build()).columnFour("Expires", Icon.called("clock").of(Family.REGULAR).build());
    }

    private Table.Factory serverTable() {
        return Table.builder().columnOne("Affects", Icon.called("user").build()).columnTwo("By", Icon.called("user-shield").build()).columnThree("Reason", Icon.called("balance-scale").build()).columnFour("Given", Icon.called("clock").build()).columnFive("Expires", Icon.called("clock").of(Family.REGULAR).build());
    }

    private String formatDate(long date) {
        return date <= 0L ? "Never" : this.formatter.format(date);
    }

    private void addRows(Table.Factory table, List<LitebansDBEntry> entries) {
        for (LitebansDBEntry entry : entries) {
            table.addRow(entry.getReason(), entry.getBannedBy(), this.formatDate(entry.getTime()), this.formatDate(entry.getExpiry()));
        }
    }

    private void addRows(Table.Factory table, QueryService queryService, List<LitebansDBEntry> entries) {
        for (LitebansDBEntry entry : entries) {
            UUID uuid = entry.getUuid();
            String affects = queryService.getCommonQueries().fetchNameOf(uuid).orElse(uuid.toString());
            table.addRow(affects, entry.getBannedBy(), entry.getReason(), this.formatDate(entry.getTime()), this.formatDate(entry.getExpiry()));
        }
    }
}

