/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.GroupProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.track.Track;

@PluginInfo(name="LuckPerms", iconName="exclamation-triangle", iconFamily=Family.SOLID, color=Color.LIGHT_GREEN)
@TabInfo.Multiple(value={@TabInfo(tab="Permission Groups", iconName="users-cog", elementOrder={}), @TabInfo(tab="Metadata", iconName="info-circle", elementOrder={})})
public class LuckPermsExtension
implements DataExtension {
    public LuckPerms getAPI() {
        try {
            return LuckPermsProvider.get();
        }
        catch (IllegalStateException e) {
            throw new NotReadyException();
        }
    }

    public User getUser(UUID playerUUID) {
        return Optional.ofNullable(this.getAPI().getUserManager().getUser(playerUUID)).orElseThrow(NotReadyException::new);
    }

    @GroupProvider(text="Primary Group", iconName="users-cog", groupColor=Color.LIGHT_GREEN)
    @Tab(value="Permission Groups")
    public String[] primaryGroup(UUID playerUUID) {
        return new String[]{this.getUser(playerUUID).getPrimaryGroup()};
    }

    @GroupProvider(text="Permission Group", iconName="users-cog", groupColor=Color.LIGHT_GREEN)
    @Tab(value="Permission Groups")
    public String[] permissionGroups(UUID playerUUID) {
        return (String[])this.getGroupNames(playerUUID).toArray(String[]::new);
    }

    private Stream<String> getGroupNames(UUID playerUUID) {
        return this.getUser(playerUUID).getNodes().stream().filter(node -> node.getKey().startsWith("group.")).map(node -> node.getKey().substring(6));
    }

    @TableProvider(tableColor=Color.ORANGE)
    @Tab(value="Permission Groups")
    public Table tracks(UUID playerUUID) {
        Set tracks = this.getAPI().getTrackManager().getLoadedTracks();
        Set groups = this.getGroupNames(playerUUID).collect(Collectors.toSet());
        Table.Factory table = Table.builder().columnOne("Track", Icon.called("ellipsis-h").build()).columnTwo("Group", Icon.called("users-cog").build());
        for (Track track : tracks) {
            track.getGroups().stream().filter(groups::contains).reduce((first, second) -> second).ifPresent(currentGroup -> table.addRow(track.getName(), currentGroup));
        }
        return table.build();
    }

    @StringProvider(text="Prefix", description="Current user prefix", priority=100, iconName="file-signature", iconColor=Color.GREEN)
    @Tab(value="Metadata")
    public String prefix(UUID playerUUID) {
        return Optional.ofNullable(this.getMetaData(playerUUID).getPrefix()).orElse("None");
    }

    @StringProvider(text="Suffix", description="Current user suffix", priority=99, iconName="file-signature", iconColor=Color.BLUE)
    @Tab(value="Metadata")
    public String suffix(UUID playerUUID) {
        return Optional.ofNullable(this.getMetaData(playerUUID).getSuffix()).orElse("None");
    }

    @TableProvider(tableColor=Color.BLUE)
    @Tab(value="Metadata")
    public Table metaTable(UUID playerUUID) {
        Map meta = this.getMetaData(playerUUID).getMeta();
        if (meta.isEmpty()) {
            throw new NotReadyException();
        }
        Table.Factory table = Table.builder().columnOne("Meta", Icon.called("info-circle").build()).columnTwo("Value", Icon.called("file-alt").build());
        meta.forEach((key, value) -> table.addRow(key, value.toString()));
        return table.build();
    }

    private CachedMetaData getMetaData(UUID playerUUID) {
        return this.getUser(playerUUID).getCachedData().getMetaData(this.getAPI().getContextManager().getStaticQueryOptions());
    }

    @StringProvider(text="Weight", description="Weight of the permission group", priority=5, iconName="weight-hanging", iconColor=Color.LIGHT_GREEN)
    public String weight(com.djrapitops.plan.extension.Group permissionGroup) {
        Group group = this.getGroup(permissionGroup.getGroupName());
        OptionalInt weight = group.getWeight();
        return weight.isPresent() ? Integer.toString(weight.getAsInt()) : "None";
    }

    private Group getGroup(String groupName) {
        return Optional.ofNullable(this.getAPI().getGroupManager().getGroup(groupName)).orElseThrow(NotReadyException::new);
    }

    @TableProvider(tableColor=Color.LIGHT_BLUE)
    @Tab(value="Permission Groups")
    public Table permissions(com.djrapitops.plan.extension.Group permissionGroup) {
        Group group = this.getGroup(permissionGroup.getGroupName());
        Table.Factory table = Table.builder().columnOne("Permission", Icon.called("object-group").build());
        group.getNodes().forEach(permission -> table.addRow(permission.getKey()));
        return table.build();
    }

    @TableProvider(tableColor=Color.ORANGE)
    @Tab(value="Permission Groups")
    public Table tracks() {
        Set tracks = this.getAPI().getTrackManager().getLoadedTracks();
        Table.Factory table = Table.builder().columnOne("Track", Icon.called("ellipsis-h").build()).columnTwo("Size", Icon.called("list").build());
        tracks.forEach(track -> table.addRow(track.getName(), track.getGroups().size()));
        return table.build();
    }
}

