/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

@PluginInfo(name="mcMMO", iconName="compass", iconFamily=Family.REGULAR, color=Color.INDIGO)
public class McMMOExtension
implements DataExtension {
    private PlayerProfile getProfile(UUID playerUUID) {
        return mcMMO.getDatabaseManager().loadPlayerProfile(playerUUID);
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE};
    }

    @TableProvider(tableColor=Color.INDIGO)
    public Table skillTable(UUID playerUUID) {
        Table.Factory table = Table.builder().columnOne("Skill", Icon.called("star").build()).columnTwo("Level", Icon.called("plus").build());
        PlayerProfile profile = this.getProfile(playerUUID);
        List skills = Arrays.stream(PrimarySkillType.values()).distinct().collect(Collectors.toList());
        for (PrimarySkillType skill : skills) {
            table.addRow(this.formatSkillName(skill.getName()), profile.getSkillLevel(skill));
        }
        return table.build();
    }

    private String formatSkillName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    @TableProvider(tableColor=Color.INDIGO)
    public Table leaderboard() {
        Table.Factory table = Table.builder().columnOne("Skill", Icon.called("star").build()).columnTwo("#1", Icon.called("user").build()).columnThree("#2", Icon.called("user").build()).columnFour("#3", Icon.called("user").build());
        List skills = Arrays.stream(PrimarySkillType.values()).distinct().collect(Collectors.toList());
        for (PrimarySkillType skill : skills) {
            List skillLeaders = mcMMO.getDatabaseManager().readLeaderboard(skill, 1, 3);
            table.addRow(this.formatSkillName(skill.getName()), this.getPlayerName(skillLeaders, 0), this.getPlayerName(skillLeaders, 1), this.getPlayerName(skillLeaders, 2));
        }
        return table.build();
    }

    private Optional<String> getPlayerName(List<PlayerStat> from, int index) {
        if (index < from.size()) {
            return Optional.ofNullable(from.get(index)).map(stat -> stat.name);
        }
        return Optional.empty();
    }
}

