/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.NuVotifierStorage;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.util.Map;

public abstract class NuVotifierExtension
implements DataExtension {
    private final NuVotifierStorage storage;

    NuVotifierExtension(NuVotifierStorage storage) {
        this.storage = storage;
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @NumberProvider(text="Votes", description="Times the player has voted", iconName="vote-yea", iconColor=Color.TEAL, showInPlayerTable=true)
    public long votes(String playerName) {
        return this.storage.getVoteCount(playerName);
    }

    @TableProvider(tableColor=Color.TEAL)
    public Table serviceVotesTable() {
        Map<String, Integer> votesPerService = this.storage.getVotesPerService();
        Table.Factory table = Table.builder().columnOne("Service", Icon.called("poll-h").build()).columnTwo("Votes", Icon.called("vote-yea").build());
        votesPerService.entrySet().stream().sorted((one, two) -> Integer.compare((Integer)two.getValue(), (Integer)one.getValue())).forEach(entry -> table.addRow(entry.getKey(), entry.getValue()));
        return table.build();
    }
}

