/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.BukkitNuVotifierExtension;
import com.djrapitops.extension.BungeeNuVotifierExtension;
import com.djrapitops.extension.SpongeNuVotifierExtension;
import com.djrapitops.plan.extension.DataExtension;
import java.util.Optional;

public class NuVotifierExtensionFactory {
    private boolean isAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Optional<DataExtension> createExtension() {
        if (!this.isAvailable("com.vexsoftware.votifier.model.Vote")) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.createNewExtension());
        }
        catch (IllegalStateException noSponge) {
            return Optional.empty();
        }
    }

    private DataExtension createNewExtension() {
        if (this.isAvailable("org.bukkit.event.EventHandler")) {
            return new BukkitNuVotifierExtension();
        }
        if (this.isAvailable("net.md_5.bungee.event.EventHandler")) {
            return new BungeeNuVotifierExtension();
        }
        if (this.isAvailable("org.spongepowered.api.event.Listener")) {
            return new SpongeNuVotifierExtension();
        }
        return null;
    }
}

