/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.query.QueryService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class NuVotifierStorage {
    private final QueryService queryService = QueryService.getInstance();

    public NuVotifierStorage() {
        this.createTable();
        this.queryService.subscribeDataClearEvent(this::recreateTable);
        this.queryService.subscribeToPlayerRemoveEvent(this::removePlayer);
    }

    private void createTable() {
        String dbType = this.queryService.getDBType();
        boolean sqlite = dbType.equalsIgnoreCase("SQLITE");
        String sql = "CREATE TABLE IF NOT EXISTS plan_votes (id int " + (sqlite ? "PRIMARY KEY" : "NOT NULL AUTO_INCREMENT") + ',' + "user_name varchar(36) NOT NULL,service varchar(150) NOT NULL,votes int NOT NULL" + (sqlite ? "" : ",PRIMARY KEY (id)") + ')';
        this.queryService.execute(sql, PreparedStatement::execute);
    }

    private void dropTable() {
        this.queryService.execute("DROP TABLE IF EXISTS plan_votes", PreparedStatement::execute);
    }

    private void recreateTable() {
        this.dropTable();
        this.createTable();
    }

    private void removePlayer(UUID playerUUID) {
        Optional<String> userName = this.queryService.getCommonQueries().fetchNameOf(playerUUID);
        if (!userName.isPresent()) {
            return;
        }
        this.queryService.execute("DELETE FROM plan_votes WHERE user_name=?", statement -> {
            statement.setString(1, (String)userName.get());
            statement.execute();
        });
    }

    public void storeVote(String userName, String service) throws ExecutionException {
        String update = "UPDATE plan_votes SET votes=votes+1 WHERE service=? AND user_name=?";
        String insert = "INSERT INTO plan_votes (votes, service, user_name) VALUES (1, ?, ?)";
        AtomicBoolean updated = new AtomicBoolean(false);
        try {
            this.queryService.execute(update, statement -> {
                statement.setString(1, service);
                statement.setString(2, userName);
                updated.set(statement.executeUpdate() > 0);
            }).get();
            if (!updated.get()) {
                this.queryService.execute(insert, statement -> {
                    statement.setString(1, service);
                    statement.setString(2, userName);
                    statement.execute();
                });
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getVoteCount(String userName) {
        String sql = "SELECT sum(votes) as count FROM plan_votes WHERE user_name=?";
        return this.queryService.query(sql, statement -> {
            statement.setString(1, userName);
            try (ResultSet set = statement.executeQuery();){
                Integer n = set.next() ? set.getInt("count") : -1;
                return n;
            }
        });
    }

    public Map<String, Integer> getVotesPerService() {
        String sql = "SELECT service, sum(votes) as count FROM plan_votes GROUP BY service";
        return this.queryService.query("SELECT service, sum(votes) as count FROM plan_votes GROUP BY service", statement -> {
            try (ResultSet set = statement.executeQuery();){
                HashMap<String, Integer> votesByService = new HashMap<String, Integer>();
                while (set.next()) {
                    votesByService.put(set.getString("service"), set.getInt("count"));
                }
                HashMap<String, Integer> hashMap = votesByService;
                return hashMap;
            }
        });
    }
}

