/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TabOrder;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Inmate;
import io.github.nucleuspowered.nucleus.api.nucleusdata.MuteInfo;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Note;
import io.github.nucleuspowered.nucleus.api.nucleusdata.TimedEntry;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warning;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warp;
import io.github.nucleuspowered.nucleus.api.service.NucleusKitService;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarpService;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

@PluginInfo(name="Nucleus", iconName="atom", iconFamily=Family.SOLID, color=Color.BLACK)
@TabInfo.Multiple(value={@TabInfo(tab="Punishments", iconName="gavel", elementOrder={ElementOrder.VALUES, ElementOrder.TABLE}), @TabInfo(tab="Homes", iconName="home", elementOrder={ElementOrder.TABLE}), @TabInfo(tab="Server", iconName="box", elementOrder={ElementOrder.TABLE})})
@TabOrder(value={"Homes", "Punishments", "Kits"})
public class NucleusExtension
implements DataExtension {
    private UserStorageService userStorageService = (UserStorageService)Sponge.getServiceManager().provide(UserStorageService.class).orElseThrow(IllegalStateException::new);

    private Optional<User> getUser(UUID playerUUID) {
        Optional player = Sponge.getServer().getPlayer(playerUUID);
        if (player.isPresent()) {
            return player.map(p -> p);
        }
        if (this.userStorageService != null) {
            return this.userStorageService.get(playerUUID);
        }
        return Optional.empty();
    }

    @BooleanProvider(text="Muted", iconName="bell-slash", iconColor=Color.DEEP_ORANGE, priority=100, conditionName="isMuted")
    @Tab(value="Punishments")
    public boolean isMuted(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getMuteService().map(service -> service.isMuted(user))).orElse(false);
    }

    @StringProvider(text="Operator", description="Who muted the player", iconName="user", iconColor=Color.DEEP_ORANGE, iconFamily=Family.REGULAR, priority=99, playerName=true)
    @Conditional(value="isMuted")
    @Tab(value="Punishments")
    public String muteOperator(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getMuteService().flatMap(service -> service.getPlayerMuteInfo(user))).flatMap(MuteInfo::getMuter).flatMap(this::getUser).map(User::getName).orElse("Unknown");
    }

    @NumberProvider(text="Date", iconName="calendar", iconColor=Color.DEEP_ORANGE, iconFamily=Family.REGULAR, priority=98, format=FormatType.DATE_SECOND)
    @Conditional(value="isMuted")
    @Tab(value="Punishments")
    public long muteStart(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getMuteService().flatMap(service -> service.getPlayerMuteInfo(user))).flatMap(MuteInfo::getCreationInstant).map(Instant::toEpochMilli).orElse(-1L);
    }

    @NumberProvider(text="Ends", iconName="calendar-check", iconColor=Color.DEEP_ORANGE, iconFamily=Family.REGULAR, priority=97, format=FormatType.DATE_SECOND)
    @Conditional(value="isMuted")
    @Tab(value="Punishments")
    public long muteEnd(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getMuteService().flatMap(service -> service.getPlayerMuteInfo(user))).flatMap(TimedEntry::getRemainingTime).map(duration -> duration.plusMillis(System.currentTimeMillis()).toMillis()).orElse(-1L);
    }

    @StringProvider(text="Reason", description="Why the player was muted", iconName="comment", iconColor=Color.DEEP_ORANGE, iconFamily=Family.REGULAR, priority=96)
    @Conditional(value="isMuted")
    @Tab(value="Punishments")
    public String muteReason(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getMuteService().flatMap(service -> service.getPlayerMuteInfo(user))).map(MuteInfo::getReason).orElse("Unspecified");
    }

    @BooleanProvider(text="Jailed", iconName="bars", iconColor=Color.AMBER, priority=90, conditionName="isJailed")
    @Tab(value="Punishments")
    public boolean isJailed(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getJailService().map(service -> service.isPlayerJailed(user))).orElse(false);
    }

    @StringProvider(text="Operator", description="Who jailed the player", iconName="user", iconColor=Color.AMBER, iconFamily=Family.REGULAR, priority=89, playerName=true)
    @Conditional(value="isJailed")
    @Tab(value="Punishments")
    public String jailOperator(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getJailService().flatMap(service -> service.getPlayerJailData(user))).flatMap(Inmate::getJailer).flatMap(this::getUser).map(User::getName).orElse("Unknown");
    }

    @NumberProvider(text="Date", iconName="calendar", iconColor=Color.AMBER, iconFamily=Family.REGULAR, priority=88, format=FormatType.DATE_SECOND)
    @Conditional(value="isJailed")
    @Tab(value="Punishments")
    public long jailStart(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getJailService().flatMap(service -> service.getPlayerJailData(user))).flatMap(Inmate::getCreationInstant).map(Instant::toEpochMilli).orElse(-1L);
    }

    @NumberProvider(text="Ends", iconName="calendar-check", iconColor=Color.AMBER, iconFamily=Family.REGULAR, priority=87, format=FormatType.DATE_SECOND)
    @Conditional(value="isJailed")
    @Tab(value="Punishments")
    public long jailEnd(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getJailService().flatMap(service -> service.getPlayerJailData(user))).flatMap(TimedEntry::getRemainingTime).map(duration -> duration.plusMillis(System.currentTimeMillis()).toMillis()).orElse(-1L);
    }

    @StringProvider(text="Reason", description="Why the player was jailed", iconName="comment", iconColor=Color.AMBER, iconFamily=Family.REGULAR, priority=96)
    @Conditional(value="isJailed")
    @Tab(value="Punishments")
    public String jailReason(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getJailService().flatMap(service -> service.getPlayerJailData(user))).map(Inmate::getReason).orElse("Unspecified");
    }

    @StringProvider(text="Jail", description="Where the player is jailed at", iconName="bars", iconColor=Color.AMBER, iconFamily=Family.REGULAR, priority=95)
    @Conditional(value="isJailed")
    @Tab(value="Punishments")
    public String jail(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getJailService().flatMap(service -> service.getPlayerJailData(user))).map(Inmate::getJailName).orElse("-");
    }

    @TableProvider(tableColor=Color.AMBER)
    @Tab(value="Punishments")
    public Table warnings(UUID playerUUID) {
        Table.Factory table = Table.builder().columnOne("Warner", Icon.called("exclamation").of(Family.SOLID).build()).columnTwo("Reason", Icon.called("sticky-note").of(Family.SOLID).build());
        List warnings = this.getUser(playerUUID).flatMap(user -> NucleusAPI.getWarningService().map(service -> service.getWarnings(user))).orElse(Collections.emptyList());
        if (warnings.isEmpty()) {
            table.addRow("No Warnings");
        } else {
            for (Warning warning : warnings) {
                String warner = warning.getWarner().flatMap(this::getUser).map(User::getName).orElse("Unknown");
                table.addRow(warner, warning.getReason());
            }
        }
        return table.build();
    }

    @StringProvider(text="Nickname", iconName="id-badge", iconColor=Color.GREEN, iconFamily=Family.REGULAR, priority=100, showInPlayerTable=true)
    public String nickname(UUID playerUUID) {
        return this.getUser(playerUUID).flatMap(user -> NucleusAPI.getNicknameService().flatMap(service -> service.getNickname(user))).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).serialize(arg_0)).orElse("-");
    }

    @NumberProvider(text="Homes", iconName="home", iconColor=Color.LIGHT_GREEN)
    @Tab(value="Homes")
    public long homeCount(UUID playerUUID) {
        return NucleusAPI.getHomeService().map(service -> service.getHomeCount(playerUUID)).orElse(0).intValue();
    }

    @TableProvider(tableColor=Color.LIGHT_GREEN)
    @Tab(value="Homes")
    public Table homes(UUID playerUUID) {
        List homes = NucleusAPI.getHomeService().map(service -> service.getHomes(playerUUID)).orElse(Collections.emptyList());
        Table.Factory table = Table.builder().columnOne("Home", Icon.called("home").build());
        for (Home home : homes) {
            table.addRow(home.getName());
        }
        return table.build();
    }

    @TableProvider(tableColor=Color.LIGHT_BLUE)
    public Table notes(UUID playerUUID) {
        List notes = this.getUser(playerUUID).flatMap(user -> NucleusAPI.getNoteService().map(service -> service.getNotes(user))).orElse(Collections.emptyList());
        Table.Factory table = Table.builder().columnOne("Noter", Icon.called("pen").of(Family.SOLID).build()).columnTwo("Note", Icon.called("sticky-note").of(Family.REGULAR).build());
        for (Note note : notes) {
            String noter = note.getNoter().flatMap(this::getUser).map(User::getName).orElse("Unknown");
            table.addRow(noter, note.getNote());
        }
        return table.build();
    }

    @TableProvider(tableColor=Color.PURPLE)
    @Tab(value="Server")
    public Table kits() {
        Table.Factory table = Table.builder().columnOne("Kit", Icon.called("box").build());
        NucleusAPI.getKitService().map(NucleusKitService::getKitNames).orElse(Collections.emptySet()).stream().sorted().forEach(xva$0 -> table.addRow(xva$0));
        return table.build();
    }

    @TableProvider(tableColor=Color.PURPLE)
    @Tab(value="Server")
    public Table warps() {
        Table.Factory table = Table.builder().columnOne("Warp", Icon.called("map-marker-alt").build()).columnTwo("Description", Icon.called("sticky-note").of(Family.REGULAR).build()).columnThree("Category", Icon.called("list").build());
        List warps = NucleusAPI.getWarpService().map(NucleusWarpService::getAllWarps).orElse(Collections.emptyList());
        for (Warp warp : warps) {
            Object[] objectArray = new Object[3];
            objectArray[0] = warp.getName();
            objectArray[1] = warp.getDescription().map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).serialize(arg_0)).orElse(null);
            objectArray[2] = warp.getCategory().orElse(null);
            table.addRow(objectArray);
        }
        return table.build();
    }
}

