/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ProtocolSupportStorage;
import com.djrapitops.extension.ProtocolSupportVersionListener;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.util.UUID;
import protocolsupport.api.ProtocolVersion;

@PluginInfo(name="ProtocolSupport", iconName="gamepad", iconFamily=Family.SOLID, color=Color.CYAN)
public class ProtocolSupportExtension
implements DataExtension {
    private final ProtocolSupportStorage storage = new ProtocolSupportStorage();

    public ProtocolSupportExtension() {
        if (this.viaVersionIsNotInstalled()) {
            new ProtocolSupportVersionListener(this.storage).register();
        }
    }

    private boolean viaVersionIsNotInstalled() {
        try {
            Class.forName("us.myles.ViaVersion.api.ViaAPI");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @StringProvider(text="Last Join Version", description="Version used last time the player joined", iconName="signal", iconColor=Color.CYAN, showInPlayerTable=true)
    public String protocolVersion(UUID playerUUID) {
        return this.getProtocolVersionString(this.storage.getProtocolVersion(playerUUID));
    }

    private String getProtocolVersionString(int number) {
        ProtocolVersion[] versions;
        if (number == -1) {
            return "Not Yet Known";
        }
        for (ProtocolVersion version : versions = ProtocolVersion.getAllSupported()) {
            String name;
            if (version.getId() != number || (name = version.getName()) == null) continue;
            return name;
        }
        return "Unknown (" + number + ')';
    }

    @TableProvider(tableColor=Color.CYAN)
    public Table protocolTable() {
        Table.Factory table = Table.builder().columnOne("Version", Icon.called("signal").build()).columnTwo("Users", Icon.called("users").build());
        this.storage.getProtocolVersionCounts().entrySet().stream().sorted((one, two) -> Integer.compare((Integer)two.getValue(), (Integer)one.getValue())).forEach(entry -> table.addRow(this.getProtocolVersionString((Integer)entry.getKey()), entry.getValue()));
        return table.build();
    }
}

