/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;

@PluginInfo(name="RedProtect", iconName="shield-alt", iconFamily=Family.SOLID, color=Color.RED)
public class RedProtectBukkitExtension
implements DataExtension {
    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @TableProvider(tableColor=Color.RED)
    public Table regionTable(UUID playerUUID) {
        return this.createRegionTable(RedProtect.get().getAPI().getPlayerRegions(playerUUID.toString()));
    }

    @NumberProvider(text="Total Area", description="Total area the player has claimed", iconName="map", iconFamily=Family.REGULAR, iconColor=Color.RED, showInPlayerTable=true)
    public long totalArea(UUID playerUUID) {
        return RedProtect.get().getAPI().getPlayerRegions(playerUUID.toString()).stream().mapToLong(Region::getArea).sum();
    }

    @TableProvider(tableColor=Color.RED)
    public Table regionTable() {
        return this.createRegionTable(RedProtect.get().getAPI().getAllRegions());
    }

    private Table createRegionTable(Set<Region> regions) {
        Table.Factory table = Table.builder().columnOne("Region", Icon.called("map-marker").build()).columnTwo("World", Icon.called("map").build()).columnThree("Area", Icon.called("map").of(Family.REGULAR).build());
        regions.stream().sorted((one, two) -> Integer.compare(two.getArea(), one.getArea())).forEach(region -> {
            int area = region.getArea();
            Location center = region.getCenterLoc();
            String location = "x: " + center.getBlockX() + ", z: " + center.getBlockZ();
            String world = region.getWorld();
            table.addRow(location, world, area);
        });
        return table.build();
    }
}

