/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.DoubleProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;

@PluginInfo(name="Sponge Economy", iconName="money-bill-wave", iconFamily=Family.SOLID, color=Color.AMBER)
public class SpongeEconomyExtension
implements DataExtension {
    private EconomyService eco;

    SpongeEconomyExtension() {
    }

    SpongeEconomyExtension(EconomyService eco) {
        this.eco = eco;
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_JOIN, CallEvents.SERVER_EXTENSION_REGISTER};
    }

    @BooleanProvider(text="", conditionName="hasAccount", hidden=true)
    public boolean hasAccount(UUID playerUUID) {
        return this.eco.hasAccount(playerUUID);
    }

    public Optional<UniqueAccount> getAccount(UUID playerUUID) {
        return this.eco.getOrCreateAccount(playerUUID);
    }

    @Conditional(value="hasAccount")
    @DoubleProvider(text="Balance (Default Currency)", description="How much currency the player has.", iconName="money-bill-wave", priority=100, iconColor=Color.AMBER, showInPlayerTable=true)
    public double balance(UUID playerUUID) {
        Currency defaultCurrency = this.eco.getDefaultCurrency();
        BigDecimal balance = this.getAccount(playerUUID).map(account -> account.getBalance(defaultCurrency)).orElse(BigDecimal.ZERO);
        return balance.doubleValue();
    }

    @StringProvider(text="Default Currency", description="What currency is used by default.", iconName="money-bill-wave", priority=101, iconColor=Color.AMBER)
    public String defaultCurrency() {
        return this.eco.getDefaultCurrency().getDisplayName().toPlain();
    }
}

