/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.NuVotifierStorage;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.sponge.event.VotifierEvent;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.plugin.PluginContainer;

public class SpongeVoteListener {
    private final NuVotifierStorage storage;
    private final PluginContainer plugin;

    SpongeVoteListener(NuVotifierStorage storage) {
        this.storage = storage;
        this.plugin = (PluginContainer)Sponge.getPluginManager().getPlugin("Plan").orElseThrow(IllegalStateException::new);
    }

    public void register() {
        Sponge.getGame().getEventManager().registerListeners((Object)this.plugin, (Object)this);
    }

    @Listener(order=Order.LAST)
    public void onJoin(VotifierEvent event) {
        Vote vote = event.getVote();
        String service = vote.getServiceName();
        String username = vote.getUsername();
        Sponge.getGame().getScheduler().createTaskBuilder().async().execute(() -> {
            try {
                this.storage.storeVote(username, service);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }).submit((Object)this.plugin);
    }
}

