/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import io.minimum.minecraft.superbvote.SuperbVote;
import io.minimum.minecraft.superbvote.storage.VoteStorage;
import io.minimum.minecraft.superbvote.util.PlayerVotes;
import java.util.UUID;
import org.bukkit.plugin.java.JavaPlugin;

@PluginInfo(name="SuperbVote", iconName="check", iconFamily=Family.SOLID, color=Color.TEAL)
public class SuperbVoteExtension
implements DataExtension {
    private VoteStorage store;

    SuperbVoteExtension(boolean forTesting) {
    }

    public SuperbVoteExtension() {
        SuperbVote plugin = (SuperbVote)JavaPlugin.getPlugin(SuperbVote.class);
        if (plugin == null) {
            throw new IllegalStateException();
        }
        this.store = plugin.getVoteStorage();
        if (this.store == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE};
    }

    @NumberProvider(text="Votes", description="How many times player has voted while SuperbVote was installed", iconName="check", iconColor=Color.TEAL, showInPlayerTable=true)
    public long votes(UUID playerUUID) {
        PlayerVotes votes = this.store.getVotes(playerUUID);
        return votes != null ? (long)votes.getVotes() : 0L;
    }
}

