/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.Group;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.annotation.GroupProvider;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.settings.SettingsService;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@PluginInfo(name="Towny", iconName="university", iconFamily=Family.SOLID, color=Color.BROWN)
public class TownyExtension
implements DataExtension {
    private Resident getResident(String playerName) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(playerName);
            if (resident == null) {
                throw new NotReadyException();
            }
            return resident;
        }
        catch (NotRegisteredException e) {
            throw new NotReadyException();
        }
    }

    private Optional<Town> getTown(String playerName) {
        Resident resident = this.getResident(playerName);
        try {
            if (resident.hasTown()) {
                Town town;
                List<String> ignoredTowns = this.getIgnoredTowns();
                if (ignoredTowns.contains((town = resident.getTown()).getName())) {
                    return Optional.empty();
                }
                return Optional.of(town);
            }
            return Optional.empty();
        }
        catch (NotRegisteredException doesNotHaveTown) {
            return Optional.empty();
        }
    }

    private List<String> getIgnoredTowns() {
        return SettingsService.getInstance().getStringList("Towny.HideTowns", () -> Collections.singletonList("ExampleTown"));
    }

    /*
     * Exception decompiling
     */
    @GroupProvider(text="Town", groupColor=Color.BROWN, iconName="university")
    public String[] town(String playerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @StringProvider(text="Mayor", description="Who runs the town", iconName="user", iconColor=Color.BROWN, priority=100, playerName=true)
    public String townMayor(Group townName) {
        return this.getTown(townName).getMayor().getName();
    }

    @StringProvider(text="Town Coordinates", description="Where is the town located", iconName="map-pin", iconColor=Color.RED, priority=95)
    public String townCoordinates(Group townName) {
        return this.getHomeBlock(townName);
    }

    private String getHomeBlock(Group townName) {
        try {
            Coord coord = this.getTown(townName).getHomeBlock().getCoord();
            return "x: " + coord.getX() + " z: " + coord.getZ();
        }
        catch (TownyException e) {
            return "Not Set";
        }
    }

    private Town getTown(Group townName) {
        try {
            return TownyUniverse.getDataSource().getTown(townName.getGroupName());
        }
        catch (NotRegisteredException e) {
            throw new NotReadyException();
        }
    }

    @NumberProvider(text="Number of Towns", description="How many towns there are", priority=105, iconName="university", iconColor=Color.BROWN)
    public long numberOfTowns() {
        List<String> ignoredTowns = this.getIgnoredTowns();
        return TownyUniverse.getDataSource().getTowns().stream().map(TownyObject::getName).filter(townName -> !ignoredTowns.contains(townName)).count();
    }

    @StringProvider(text="Nation", description="What nation is the town part of", priority=90, iconName="flag", iconColor=Color.BROWN)
    public String nation(Group townName) {
        return this.getNation(townName).map(TownyObject::getName).orElse("None");
    }

    private Optional<Nation> getNation(Group townName) {
        try {
            Town town = this.getTown(townName);
            if (town.hasNation()) {
                return Optional.of(town.getNation());
            }
            return Optional.empty();
        }
        catch (NotRegisteredException e) {
            return Optional.empty();
        }
    }
}

