/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.EconomyExtension;
import com.djrapitops.extension.PermissionsExtension;
import com.djrapitops.plan.extension.DataExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;

public class VaultExtensionFactory {
    private boolean isAvailable() {
        try {
            Class.forName("net.milkbowl.vault.Vault");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Collection<DataExtension> createExtensions() {
        if (!this.isAvailable()) {
            return Collections.emptyList();
        }
        ArrayList<DataExtension> extensions = new ArrayList<DataExtension>();
        this.getExtension(EconomyExtension::new).ifPresent(extensions::add);
        this.getExtension(PermissionsExtension::new).ifPresent(extensions::add);
        return extensions;
    }

    private Optional<DataExtension> getExtension(Supplier<DataExtension> constructor) {
        try {
            return Optional.of(constructor.get());
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError throwable) {
            return Optional.empty();
        }
    }
}

